% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GKtau.R
\name{GKtau}
\alias{GKtau}
\title{Compute Goodman and Kruskal tau measure of association.}
\usage{
GKtau(x, y, dgts = 3, includeNA = "ifany")
}
\arguments{
\item{x}{A categorical vector (factor).}

\item{y}{A categorical vector (factor).}

\item{dgts}{Integer, number of digits for results; optional (default = 3).}

\item{includeNA}{Character, passed to useNA parameter for table;
default is "ifany"; other valid options are "no" and "always"}
}
\value{
A one-row dataframe with the following columns:
\itemize{
  \item the names of the x and y variables,
  \item the numbers of distinct values Nx and Ny for each variable, and
  \item the forward and backward associations, tau(x,y) and tau(y,x).
}
}
\description{
\code{GKtau} returns forward and backward Goodman and Kruskal tau measures
between categorical variables.
}
\details{
The Goodman and Kruskal tau measure is an asymmetric association measure
between two categorical variables, based on the extent to which variation
in one variable can be explained by the other.  This function returns a
dataframe with both forward and backward associations.
}
\examples{
x <- rep(c("a", "b", "c", "d"), each = 3)
y <- rep(c("a", "b", "c", "d"), times = 3)
z <- rep(c("a", "b", "a", "c"), each = 3)
GKtau(x, y)
GKtau(x, z)
GKtau(y, z)

}
\author{
Ron Pearson
}
