% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ave_tp.R
\name{plots_av_tp}
\alias{plots_av_tp}
\title{Returns average deuteration plot for timepoints in the data frame}
\usage{
plots_av_tp(df, replicates = 3, cola)
}
\arguments{
\item{df}{output from functions output_tp or output_tp_proc.}

\item{replicates}{number of replicates in set as default set to 3.}

\item{cola}{color pallette for different Protein States. As default Paired pallette from color.Brewer is used.}
}
\value{
average deuteration plots
}
\description{
Returns plots with average deuteration at each peptide.
}
\examples{
file_nm<-system.file("extdata", "All_results_table.csv", package = "HDXBoxeR")
a<- output_tp(file_nm)
plots_av_tp(df=a, replicates=3, cola=c(1:4))
plots_av_tp(df=a)
}
