% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gestureVelocity.R
\docType{data}
\name{gestureVelocity}
\alias{gestureVelocity}
\title{Gesture Phase Segmentation}
\format{A data frame with 1743 observations on the following 33 variables.
  \describe{
    \item{\samp{1}}{Vectorial velocity of left hand (x coordinate)}
    \item{\samp{2}}{Vectorial velocity of left hand (y coordinate)}
    \item{\samp{3}}{Vectorial velocity of left hand (z coordinate)}
    \item{\samp{4}}{Vectorial velocity of right hand (x coordinate)}
    \item{\samp{5}}{Vectorial velocity of right hand (y coordinate)}
    \item{\samp{6}}{Vectorial velocity of right hand (z coordinate)}
    \item{\samp{7}}{Vectorial velocity of left wrist (x coordinate)}
    \item{\samp{8}}{Vectorial velocity of left wrist (y coordinate)}
    \item{\samp{9}}{Vectorial velocity of left wrist (z coordinate)}
    \item{\samp{10}}{Vectorial velocity of right wrist (x coordinate)}
    \item{\samp{11}}{Vectorial velocity of right wrist (y coordinate)}
    \item{\samp{12}}{Vectorial velocity of right wrist (z coordinate)}
    \item{\samp{13}}{Vectorial acceleration of left hand (x coordinate)}
    \item{\samp{14}}{Vectorial acceleration of left hand (y coordinate)}
    \item{\samp{15}}{Vectorial acceleration of left hand (z coordinate)}
    \item{\samp{16}}{Vectorial acceleration of right hand (x coordinate)}
    \item{\samp{17}}{Vectorial acceleration of right hand (y coordinate)}
    \item{\samp{18}}{Vectorial acceleration of right hand (z coordinate)}
    \item{\samp{19}}{Vectorial acceleration of left wrist (x coordinate)}
    \item{\samp{20}}{Vectorial acceleration of left wrist (y coordinate)}
    \item{\samp{21}}{Vectorial acceleration of left wrist (z coordinate)}
    \item{\samp{22}}{Vectorial acceleration of right wrist (x coordinate)}
    \item{\samp{23}}{Vectorial acceleration of right wrist (y coordinate)}
    \item{\samp{24}}{Vectorial acceleration of z coordinate (z coordinate)}
    \item{\samp{25}}{Scalar velocity of left hand}
    \item{\samp{26}}{Scalar velocity of right hand}
    \item{\samp{27}}{Scalar velocity of left hand}
    \item{\samp{28}}{Scalar velocity of right wrist}
    \item{\samp{29}}{Scalar velocity of left hand}
    \item{\samp{30}}{Scalar velocity of right hand}
    \item{\samp{31}}{Scalar velocity of left wrist}
    \item{\samp{32}}{Scalar velocity of right wrist}
    \item{\code{Phase}}{Phase of gesture: D(rest position),P(preparation),S(stroke),H(hold),R(retraction)}
  }}
\source{
{
\url{https://archive.ics.uci.edu/ml/datasets/gesture+phase+segmentation#}}

1. Madeo, R. C. B. ; Lima, C. A. M. ; PERES, S. M. . Gesture Unit Segmentation using Support Vector Machines: Segmenting
Gestures from Rest Positions. In: Symposium on Applied Computing (SAC), 2013, Coimbra. Proceedings of the 28th Annual
ACM Symposium on Applied Computing (SAC), 2013. p. 46-52.

2. Wagner, P. K. ; PERES, S. M. ; Madeo, R. C. B. ; Lima, C. A. M. ; Freitas, F. A. . Gesture Unit Segmentation Using
Spatial-Temporal Information and Machine Learning. In: 27th Florida Artificial Intelligence Research Society Conference
(FLAIRS), 2014, Pensacola Beach. Proceedings of the 27th Florida Artificial Intelligence Research Society Conference
(FLAIRS). Palo Alto : The AAAI Press, 2014. p. 101-106.
}
\usage{
gestureVelocity
}
\description{
The dataset is composed of features extracted from 7 videos with people gesticulating, aiming at studying gesture phase segmentation. It contains velocity and acceleration recording of the experimental subjects' hands and wrists.
}
\keyword{datasets}
