% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toHTML.R
\name{toHTML.html_matrix}
\alias{toHTML.html_matrix}
\alias{toHTML.table}
\alias{toHTML.matrix}
\title{toHTML}
\usage{
\method{toHTML}{html_matrix}(x, browser = FALSE, ...)

\method{toHTML}{table}(x, browser = FALSE, ...)

\method{toHTML}{matrix}(x, browser = FALSE, ...)
}
\arguments{
\item{x}{html_matrix object}

\item{browser}{logical: show HTML in a browser (default: \code{FALSE})}

\item{...}{further parameters to \code{\link[utils:browseURL]{utils::browseURL()}}}
}
\value{
html_matrix object
}
\description{
Returns a HTMl representation of a matrix and optionally shows the result in the browser.
If you decide to view the result in a browser then the HTML will be written to a temporary file and
\code{\link[utils:browseURL]{utils::browseURL()}} called
}
\examples{
library("tools")
m    <- matrix(1:12, ncol=4)
hm   <- html_matrix(m)
html <- toHTML(hm, browser=interactive())
}
