% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_direct.R
\name{n_direct}
\alias{n_direct}
\title{Compute total channel roughness via direct field measurement}
\usage{
n_direct(radius, slope, velocity, restrict = TRUE)
}
\arguments{
\item{radius}{hydraulic radius (R) in meters}

\item{slope}{channel slope (S) in m/m}

\item{velocity}{average velocity (U) in meters per second}

\item{restrict}{allows for function parameters to restrict certain values. Type bool. Default TRUE.}
}
\value{
Manning's n
}
\description{
\code{n_direct} calculate Manning's n using direct measurements
}
\examples{
# Result: Manning's n of 0.710 
n_direct(2,0.05,0.5)

# Result: Manning's n of 3.216
n_direct(10,0.03,0.25)

# Result: Manning's n of 5.440
n_direct(22,0.12,0.5)

# Result: Hydraulic radius cannot be negative.
n_direct(-2,0.12,0.5)

}
