% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_limerinos1970.R
\name{n_limerinos1970}
\alias{n_limerinos1970}
\title{Compute grain roughness following Limerinos (1970)}
\usage{
n_limerinos1970(radius, grain, restrict = TRUE)
}
\arguments{
\item{radius}{hydraulic radius (R) in meters. The original model was calibrated
for 0.31 m < R < 3.32 m.}

\item{grain}{grain size (d84) in millimeters. The original model was calibrated
for 19 mm < d84 < 747 mm}

\item{restrict}{allows for function parameters to restrict certain values. Type bool. Default TRUE.}
}
\value{
Manning's n
}
\description{
\code{n_limerinos1970} calculate Manning's n using the Limerinos (1970) method
for estimating grain roughness
}
\examples{
# Result: Manning's n of 0.036
n_limerinos1970(1,100)

# Result: Manning's n of 0.031
n_limerinos1970(2.5,70)

# Result: Manning's n of 0.039
n_limerinos1970(3,200)

# Result: Manning's n of 0.039
n_limerinos1970(3,200)

# Result: Grain must be within 19 and 747 mm.
n_limerinos1970(3,1000)

}
\references{
Limerinos, J. T. 1970. Determination of the Manning Coefficient from Measured
Bed Roughness in Natural Channels. Water Supply Paper 1898-B. USGS, Washington, DC.
}
