% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_aggregated_uptake_structure.R
\name{get_structure_color}
\alias{get_structure_color}
\title{Get color palette for 3D structure}
\usage{
get_structure_color(
  aggregated_dat,
  differential = FALSE,
  fractional = TRUE,
  theoretical = FALSE,
  time_t
)
}
\arguments{
\item{aggregated_dat}{aggregated data, either for single uptake or differential}

\item{differential}{indicator if the aggregated_dat contains differential 
results}

\item{fractional}{indicator if fractional values are used}

\item{theoretical}{indicator if theoretical values are used}

\item{time_t}{time point from aggregated_dat to be shown on the structure}
}
\value{
a list
}
\description{
This function provides a set of color codes associated with aggregated values
to be presented on 3D structure.
}
\examples{
\donttest{
# disabled due to long execution time 

diff_uptake_dat <- create_diff_uptake_dataset(alpha_dat)
diff_aggregated_dat <- create_aggregated_diff_uptake_dataset(diff_uptake_dat)
get_structure_color(diff_aggregated_dat, 
                    differential = TRUE,
                    time_t = 1)
}

}
