% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/had_goethals_T.R
\name{had_goethals_T}
\alias{had_goethals_T}
\title{had_goethals_T
had_goethals_Turyn performs the Hadamard Matrix from Goethals-Seidel method
by using T sequences.}
\source{
The T sequences are available at London (2013)  and
The Base sequences were obtained from \href{http://www.math.ntua.gr/~ckoukouv/}{Christos Koukouvinos}
}
\usage{
had_goethals_T(n)
}
\arguments{
\item{n}{integer (order of the matrix)}
}
\value{
Hadamard matrix of order x
}
\description{
had_goethals_T
had_goethals_Turyn performs the Hadamard Matrix from Goethals-Seidel method
by using T sequences.
}
\details{
This function construct Hadamard matrix of given order using T sequences.
If T sequences of length n,n,n,n are available, Hadamard matrix of order 4n can be constructed.
Returns the Hadamard matrix of given order. If for given order the T sequences are not available
returns NULL.

The T sequences are stored in internal dataset. The available
T sequences of length is seq(1,73,2) and 83, 101 and 107
}
\examples{
had_goethals_T(4)
#      [,1] [,2] [,3] [,4]
# [1,]    1   -1   -1   -1
# [2,]    1    1   -1    1
# [3,]    1    1    1   -1
# [4,]    1   -1    1    1
had_goethals_T(8)
#NULL
}
\references{
Goethals, J. M. and Seidel, J. J. (1967). Orthogonal matrices with zero diagnol. Canad. J. Math., 19, 259-264.

London, S. 2013. Constructing New Turyn Type Sequences, T-Sequences and Hadamard Matrices. PhD Thesis, University of Illinois at Chicago, Chicago.
}
