% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectories.R
\name{prune}
\alias{prune}
\title{Prune trajectories}
\usage{
prune(D.list, top.n = 10)
}
\arguments{
\item{D.list}{List of distance matrices. Can be generated by the distmat function.}

\item{top.n}{Prune trajectories to only top.n possible connections to optimize subsequent application of the mincostflow function.}
}
\value{
Pruned distance matrix between cells from multiple timepoints.
}
\description{
Prune trajectories down to top.n candidates to reduce runtime of subsequent mincostflow function.
}
\examples{
\donttest{

# Full vignette available on https://grandr.erhard-lab.de/articles/web/hetseq.html

  prune(D.list, top.n = 10)
}
}
