#' Example HiC data file path
#'
#' @return The file path to the example HiC data.
#' @export
#' @examples
#' get_example_hic_path()
get_example_hic_path <- function(){
  filename <- system.file('extdata', 'example.hic', package = 'HiCocietyExample')
  return(filename)
}

#' Example HiCociety object for naive CD4+ T cells of mice
#'
#' @return The HiCociety object for the naive CD4+ T cells of mice.
#' @export
#' @examples
#' get_example_HiCociety_obj_mouse_naiveCD4T()
get_example_HiCociety_obj_mouse_naiveCD4T <- function(){
  filename <- system.file('extdata', 'mouse_naiveCD4T_Vahedi_short.rds', package = 'HiCocietyExample')
  myobj <- readRDS(filename)
  return(myobj)
}

#' Example HiCociety object for Th1 cells of mice
#'
#' @return The HiCociety object for the Th1 cells of mice.
#' @export
#' #' get_example_HiCociety_obj_mouse_Th1()
get_example_HiCociety_obj_mouse_Th1 <- function(){
  filename <- system.file('extdata', 'mouse_Th1_Vahedi_short.rds', package = 'HiCocietyExample')
  myobj <- readRDS(filename)
  return(myobj)
}
