% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{hic2community}
\alias{hic2community}
\title{Create module objects from the Hi-C data}
\usage{
hic2community(
  fname,
  chr,
  resol,
  nbprob,
  farthest,
  par.noise = 1,
  network.cluster.method = "louvain",
  n_cores = NULL
)
}
\arguments{
\item{fname}{Path to .hic file}

\item{chr}{chromosome numbers to run.}

\item{resol}{Resolution of Hi-C data}

\item{nbprob}{Negative binomial probability. Higher value gives smaller number of stronger interaction.}

\item{farthest}{The maximum searching distance between two nodes}

\item{par.noise}{Parameter for noise removal. Default is 1, higher value gives more filtered interactions.}

\item{network.cluster.method}{Can select between 'louvain' as default and 'label_prop' which means the label propagation method.}

\item{n_cores}{The number of cores used for parallel computing. If set as NULL, n_cores is automatically set to the number of cores in the computer if it is not exceed 30. If it is more than 30, it is set as 30. Default = NULL}
}
\value{
A \code{list} containing three elements: \code{Graphs} (an \code{igraph} object representing significant chromatin interactions for each chromosome), \code{ModuleSummary} (a \code{data.frame} containing information about chromatin interaction modules), and \code{ModuleElements} (a \code{list} of nodes forming significant chromatin interactions within each module).
}
\description{
It generates a list of graph of significant interactions, module table and module elements.
}
\details{
It generates a list of graph of significant interactions, module table and module elements.
}
\examples{
# This example might take a long time to run, so we wrap it in donttest{}
\donttest{
myhic=system.file('extdata', 'example.hic', package ='HiCocietyExample')
mycom = hic2community(myhic, "19", 5000, 0.975, 2000000,
par.noise=1, 'louvain', n_cores=2)
}
}
\author{
Sora Yoon, PhD
}
