% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimation_MOM.R
\name{GetEstimate_MOM}
\alias{GetEstimate_MOM}
\title{Moment estimate of a distribution}
\usage{
GetEstimate_MOM(y, dist)
}
\arguments{
\item{y}{numeric vector, data}

\item{dist}{character, distribution name}
}
\value{
A list with the following components:
    \item{par}{numeric vector, estimated parameter vector.}
    \item{obj}{numeric, objective fonction (NA for this estimate)}
    \item{ok}{logical, did computation succeed?}
    \item{err}{integer, error code (0 if ok)}
    \item{message}{error message}
}
\description{
Returns an estimate of a distribution using the method of moments.
Note that for some distributions, this is not strictly speaking the moment estimate.
For LogPearsonIII for instance, the moment estimate of log(data) is used.
Also for GPD3, the threshold is estimated as min(data).
}
\examples{
y=c(9.2,9.5,11.4,9.5,9.4,9.6,10.5,11.1,10.5,10.4)
GetEstimate_MOM(y,'Normal')
GetEstimate_MOM(y,'LogNormal')
GetEstimate_MOM(y,'Gumbel')
GetEstimate_MOM(y,'GEV')
GetEstimate_MOM(y,'Poisson')
}
