
#' @title ICAOD: Finding Optimal Designs for Nonlinear Models Using the Imperialist Competitive Algorithm
#'
#' @description
#' Different functions are available to find optimal designs for linear and nonlinear models
#' using the imperialist competitive algorithm (ICA). Because optimality criteria depend on unknown
#' model parameters, users may choose among the following methods:
#'
#' \describe{
#'   \item{\code{\link{locally}}}{Finds locally optimal designs.}
#'   \item{\code{\link{bayes}}}{Finds Bayesian optimal designs with a continuous prior.}
#'   \item{\code{\link{robust}}}{Finds robust average-optimal designs using a discrete prior.}
#'   \item{\code{\link{minimax}}}{Finds minimax and standardized maximin optimal designs.}
#'   \item{\code{\link{multiple}}}{Locally multiple-objective optimal designs for Hill models.}
#'   \item{\code{\link{bayescomp}}}{Compound DP‑optimal Bayesian designs for binary models.}
#' }
#'
#' Additional sensitivity-verification functions:
#'
#' \describe{
#'   \item{\code{\link{senslocally}}}{Sensitivity for locally optimal designs.}
#'   \item{\code{\link{sensrobust}}}{Sensitivity for robust optimal designs.}
#'   \item{\code{\link{sensbayes}}}{Sensitivity for Bayesian designs.}
#'   \item{\code{\link{sensminimax}}}{Sensitivity for minimax designs.}
#'   \item{\code{\link{sensmultiple}}}{Sensitivity for multiple objective designs.}
#'   \item{\code{\link{sensbayescomp}}}{Sensitivity for compound DP Bayesian designs.}
#' }
#'
#' @details
#' Further methodological background can be found in Masoudi et al. (2017, 2019).
#'
#' @references
#' Masoudi E, Holling H, Wong WK (2017). *Application of Imperialist Competitive Algorithm to Find Minimax and Standardized Maximin Optimal Designs*. Computational Statistics & Data Analysis, 113, 330–345.
#'
#' Masoudi E, Holling H, Duarte BP, Wong WK (2019). *Metaheuristic Adaptive Cubature‑Based Algorithm to Find Bayesian Optimal Designs for Nonlinear Models*. Journal of Computational and Graphical Statistics.
#'
#' @name ICAOD
#' @docType package
"_PACKAGE"
