% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diag_idea.R
\name{diag_idea}
\alias{diag_idea}
\title{Run a complete IDEA4 diagnosis}
\usage{
diag_idea(
  input,
  output_directory,
  type = "single",
  export_type = c("report", "local"),
  plot_choices = c("dimensions", "trees", "radars"),
  report_format = "pdf",
  prefix = NULL,
  dpi = 320,
  append = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{input}{a character vector with path names to a single file, multiple files or even a directory with IDEA data. File extensions can either be \code{json} or \code{xls(x)}}

\item{output_directory}{the output directory for the rendered reports and/or plots. Defaults to "IDEATools_output"}

\item{type}{the type of analysis to perform. Can be "single" for single farm-related results, "group" for group-related results, "group_reference" for anonymous group-related results, or a combination of the latter, provided that the number of farms is at least 3. Note that "group_reference" is a special option designed to work with an online platform using this package (WEBIDEA)}

\item{export_type}{the type of output to produce. Can be either "report" to produce compiled reports and/or "local" to write raw plots. If NULL, the algorithm will not produce any plots on machine and will return a list with the IDEA results.}

\item{plot_choices}{the type of plots to be produced. Can be either "dimensions", "trees" or "radars" or a combination of these 3. Ignored if the export type is "report".}

\item{report_format}{a string indicating the output format if \code{type = "report"}. Can be a single format (e.g \code{"pdf"}) or multiple formats (e.g. \code{c("pdf","xlsx")}). Possible formats are "pdf", "docx", "pptx" and "xlsx"}

\item{prefix}{a prefix which will be added to output files names. Typically, the name of the farm. Ignored if \code{length(input) > 1} or in the case of a group analysis : the \code{metadata$MTD_01} field will be used to identify each farm.}

\item{dpi}{ggplot output resolution.}

\item{append}{In the case of a single excel report and if the input is an xlsx file, should the results be appended to the original file ?}

\item{quiet}{A command to remove console printing.}
}
\value{
Either reports and/or raw plots in \code{output_directory} or a named list with all the results.
}
\description{
This is a wrapper function designed to compute a complete IDEA4 diagnosis with a single function. According to the user's input, functions from IDEATools will be sequentially called to produce the desired output.
}
\details{
This function is designed to provide the user a single function to use for a full IDEA4 diagnosis.

If the input is a single file, then a simple "\code{read_idea() |> compute_idea() |> plot_idea() |> write_idea()}" or "\code{old_idea() |> plot_idea() |> write_idea()}" pipeline will be used. If export_type is NULL, then the output of \code{plot_idea()} will be returned.

If the input is a list of files and/or a directory, and if type is "single", then the single analysis pipelines are iterated over each file. If export_type is NULL, then the multiple outputs of \code{plot_idea()} are gathered in an unique list and returned.

If the input is a list of files and/or a directory, and if type is "group*", then the "import" (\code{read_idea() |> compute_idea()} or \code{old_idea()}) pipeline is iterated over each file and the results are gathered in an object of class "IDEA_group_data". This object introduced in the \code{plot_idea() |> write_idea()} pipeline will trigger a new algorithm suited to group analysis. If export_type is NULL, then the output of \code{plot_idea()} will be returned.
}
\examples{
library(IDEATools)
path <- system.file("example_data/idea_example_1.json", package = "IDEATools")
group_path <- system.file("example_data", package = "IDEATools")

# Find your temporary directory (the output will be there)
tempdir <- tempdir()

# Run a full individual diagnosis with no export, with only trees
my_diagnosis <- diag_idea(
  input = path,
  output_directory = tempdir,
  type = "single",
  export_type = NULL,
  prefix = "Farm_A",
  plot_choices = "trees",
  dpi = 20,  ## Can be much higher
  quiet = TRUE
)
}
