\name{msp2FSdb}
\alias{msp2FSdb}
\title{
msp to Fragmentation Spectra DataBase (FSDB)
}
\description{
This function converts .msp (mass spectra format) files into a readable R object.
}
\usage{
msp2FSdb(path, MSPfile_vector = "", massIntegrationWindow = 0,
allowedNominalMass = FALSE, allowedWeightedSpectralEntropy = TRUE,
noiseRemovalRatio = 0.01, number_processing_threads = 1)
}
\arguments{
  \item{path}{
Address of .msp file(s)
}
  \item{MSPfile_vector}{
A vector of names of .msp files or one .msp file name.
}
  \item{massIntegrationWindow}{
Mass window in Da to integrate adjacent peaks in the fragmentation spectra
}
  \item{allowedNominalMass}{
c(TRUE, FALSE). Select `TRUE` only for nominal mass analysis.
}
  \item{allowedWeightedSpectralEntropy}{
c(TRUE, FALSE). Weighted entropy to transform low abundant signals prior to calculating entropy similarity score. Please see the reference for details on wight transformation.
}
  \item{noiseRemovalRatio}{
noise removal ratio ([0 - 1])relative to the basepeak to measure entropy similarity score.
}
  \item{number_processing_threads}{
Number of processing threads for multi-threaded processing
}
}
\note{
This function was designed not only to achieve the fastest computational speed; but also can standardize .msp files that were generated by inconsistent settings.
}
\value{
  \item{logFSdb}{
Parameters used to create the FSDB object
}
  \item{PrecursorMZ}{
A vector of precursor m/z values
}
  \item{Precursor Type}{
A vector of precursor adduct types
}
  \item{Retention Time}{
A vector of retention time values
}
  \item{Num Peaks}{
A vector of num peaks values indicating number of ions for each fragment spectra
}
  \item{Spectral Entropy}{
A vector of spectral entropy values
}
  \item{FragmentList}{
A list of fragment ions
}
  \item{MSPLibraryParameters}{
A dataframe of tabulated headers and their values for each msp block
}
}
\references{
Li, Y., Kind, T., Folz, J., Vaniya, A., Mehta, S.S. and Fiehn, O. (2021). Spectral entropy outperforms MS/MS dot product similarity for small-molecule compound identification. \emph{Nature methods}, 18(12), 1524-1531, \doi{10.1038/s41592-021-01331-z}
}
\examples{
path_extdata <- system.file("extdata", package = "IDSL.FSA")
MSPfile <- c("Kynurenine_Kynurenic_acid.msp")
sampleFSdb <- msp2FSdb(path = path_extdata, MSPfile)
}