% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcMI.R
\name{calcMI}
\alias{calcMI}
\title{Calculate Mutual information (MI)}
\usage{
calcMI(df)
}
\arguments{
\item{df}{A data frame with the first column indicating individual identity.}
}
\value{
Numeric value of mutual information (in bits).
}
\description{
This function calculates Mutual information of actual and predicted
individual identities in the dataset. It uses Linear discrimination analysis
(MASS::lda) to predict individual identity. Settings for LDA are identical to
those used in \code{calcDS} function, i.e., LDA uses leave-one-out
cross-validation and priors are equal for each individual in dataset. \cr\cr
\strong{Reference:} Mathevon, N., Koralek, A., Weldele, M., Glickman, S. E.,
& Theunissen, F. E. (2010). What the hyena’s laugh tells: Sex, age, dominance
and individual signature in the giggling call of Crocuta crocuta. BMC
Ecology, 10, 9-Article No.: 9. doi:10.1186/1472-6785-10-9 \cr\cr
}
\examples{
calcMI(ANmodulation)

}
\seealso{
\code{\link{calcPIC}}, \code{\link{calcHS}}

Other individual identity metrics: \code{\link{calcDS}},
  \code{\link{calcF}}, \code{\link{calcHM}},
  \code{\link{calcHSngroups}},
  \code{\link{calcHSnpergroup}}, \code{\link{calcHSntot}},
  \code{\link{calcHSvarcomp}}, \code{\link{calcHS}},
  \code{\link{calcPICbetweenmeans}},
  \code{\link{calcPICbetweentot}}, \code{\link{calcPIC}}
}
\concept{individual identity metrics}
