% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_rm_regions.R
\name{data_rm_regions}
\alias{data_rm_regions}
\title{Remove Region from an IFC_data Object}
\usage{
data_rm_regions(obj, regions, list_only = TRUE, adjust_graph = TRUE, ...)
}
\arguments{
\item{obj}{an `IFC_data` object extracted by ExtractFromDAF(extract_features = TRUE) or ExtractFromXIF(extract_features = TRUE).}

\item{regions}{a character vector of regions names to remove within 'obj'.}

\item{list_only}{whether to return a list of elements that will be impacted by the removal. Default is TRUE.
If FALSE then modified object will be returned.}

\item{adjust_graph}{whether to try to adjust graph(s) when possible. Default is TRUE.\cr
-TRUE, graph(s) will be kept if possible using only regions, pops it depends that can be found in 'obj',\cr
-FALSE, graph(s) will be kept only if all features, regions, pops it refers to are found in 'obj',\cr
-NA, graph(s) will be removed no matter if features, regions, pops it refers to are found in 'obj'.}

\item{...}{Other arguments to be passed.}
}
\value{
an `IFC_data` object or a list of elements impacted by removal depending on 'list_only' parameter.
}
\description{
Removes regions from an already existing `IFC_data` object.
}
