% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repmean.R
\name{repmean}
\alias{repmean}
\title{Mean, Variance and Standard Deviation with Replicate Weights}
\usage{
repmean(
  x,
  PV = FALSE,
  setup = NULL,
  repwt,
  wt,
  df,
  method,
  var = c("unbiased", "ML"),
  group = NULL,
  by = NULL,
  exclude = NULL,
  aggregates = c("pooled", "composite"),
  zones = NULL
)
}
\arguments{
\item{x}{a string vector specifying variable names (within \code{df}) for
analysis.}

\item{PV}{a logical value indicating if the variables in \code{x} are
plausible values.}

\item{setup}{an optional list produced by \code{\link{repsetup}}.}

\item{repwt}{a string indicating the common names for the replicate weights
columns (within \code{df}), or a data frame with the replicate weights.}

\item{wt}{a string specifying the name of the column (within \code{df}) with the
total weights.}

\item{df}{a data frame.}

\item{method}{a string indicating the name of the replication method.
Available options are:
\code{"JK2-full"}, \code{"JK2-half"},
\code{"FAY-0.5"},
and \code{"JK2-half-1PV"}. \cr\cr
Additionally, ILSA names can be used, defaulting into:
\itemize{
\item \code{"TIMSS"} or \code{"PIRLS"} for \code{"JK2-full"};
\item \code{"ICILS"}, \code{"ICCS"}, or \code{"CIVED"} for \code{"JK2-half"};
\item \code{"PISA"} or \code{"TALIS"} for \code{"FAY-0.5"};
\item and \code{"oldTIMSS"} or \code{"oldPIRLS"} for \code{"JK2-half-1PV"}.
}
Note that \code{"oldTIMSS"} and \code{"oldPIRLS"}
refer to the method used for TIMSS and PIRLS before 2015,
where within imputation variance
is estimated using only 1 plausible value.}

\item{var}{a string indicating the method to use for the variance:
\code{"unbiased"} calculates the unbiased estimate (n-1); \code{"ML"}
calculates the maximum likelihood estimate.}

\item{group}{a string specifying the variable name (within \code{df}) to be
used for grouping. Categories in \code{group} are treated as independent, e.g.,
countries.}

\item{by}{a string specifying a second variable (within \code{df}) for grouping.
Categories used in \code{by} are not considered independent, e.g., gender
within a country. If used,
the output will be a list with the same length as the  unique values of
\code{by}. This can only be used for analyses with one variable or a group
of PVs.}

\item{exclude}{a vector indicating which groups
(in the same format as \code{group})
should be excluded from the pooled and composite estimates.}

\item{aggregates}{a string vector indicating which aggregates should be
included, options are \code{"pooled"} and \code{"composite"}, both options can be
used at the same time. If \code{NULL} no aggregate will be estimated.}

\item{zones}{a string specifying the name of the variable containing the
replicate zones.
Used for calculating the number of zones to be used by variable and group.
If \code{NULL}, zones are not be calculated.}
}
\value{
a data frame or a list.
}
\description{
Estimates the mean, variance and standard deviation with replicate weights
for a variable or a group of variables and for one or more
populations. For a detailed explanation on how the standard errors are estimated
see \code{\link{repse}}.
}
\examples{
# Creation of replicate weights
RW <- repcreate(df = repdata, # the data frame with all the information
                 wt = "wt", # the total weights column name
                 jkzone = "jkzones", # the jkzones column name
                 jkrep = "jkrep", # the jkreps column name
                 repwtname = "REPWT", # the desired name for the rep weights
                 reps = 50, # the number of replications
                 method = "ICILS") # the name of the method aka the study name

### No groups ----

# One variable - weights within df
repmean(x = c("item01"),
        PV = FALSE,
        repwt = "REPWT", wt = "wt", df = cbind(repdata,RW),
        method = "ICILS",var = "ML",zones = "jkzones")

# One variable - weights as a separate data frame
repmean(x = c("item01"),
        PV = FALSE,
        repwt = RW, wt = "wt", df = repdata,
        method = "ICILS",var = "ML",zones = "jkzones")

# Multiple variables
repmean(x = c("item01","item02","item03"),
        PV = FALSE,
        repwt = RW, wt = "wt", df = repdata,
        method = "ICILS",var = "ML",zones = "jkzones")

# One PV variable
repmean(x = paste0("Math",1:5),
        PV = TRUE, # if set to TRUE, PVs will be treated as separate variables
        repwt = RW, wt = "wt", df = repdata,
        method = "ICILS",var = "ML",zones = "jkzones")

### Groups ----

# One variable
repmean(x = c("item01"),
        PV = FALSE,
        repwt = RW, wt = "wt", df = repdata,
        method = "ICILS",var = "ML",zones = "jkzones",
        group = "GROUP",
        exclude = "GR2") # GR2 will not be used for Pooled nor Composite

# Multiple variables
repmean(x = c("item01","item02","item03"),
        PV = FALSE,
        repwt = RW, wt = "wt", df = repdata,
        method = "ICILS",var = "ML",zones = "jkzones",
        group = "GROUP",
        exclude = "GR2") # GR2 will not be used for Pooled nor Composite

# One PV variable
repmean(x = paste0("Math",1:5),
        PV = TRUE, # if set to TRUE, PVs will be treated as separate variables
        repwt = RW, wt = "wt", df = repdata,
        method = "ICILS",var = "ML",zones = "jkzones",
        group = "GROUP",
        exclude = "GR2") # GR2 will not be used for Pooled nor Composite

### Groups and By ----

# One variable
repmean(x = c("item01"),
        PV = FALSE,
        repwt = RW, wt = "wt", df = repdata,
        method = "ICILS",var = "ML",zones = "jkzones",
        group = "GROUP",
        by = "GENDER", # results will be separated by GENDER
        exclude = "GR2") # GR2 will not be used for Pooled nor Composite

# One PV variable
repmean(x = paste0("Math",1:5),
        PV = TRUE, # if set to TRUE, PVs will be treated as separate variables
        repwt = RW, wt = "wt", df = repdata,
        method = "ICILS",var = "ML",zones = "jkzones",
        group = "GROUP",
        by = "GENDER", # results will be separated by GENDER
        exclude = "GR2") # GR2 will not be used for Pooled nor Composite
}
