% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repquant.R
\name{repquant}
\alias{repquant}
\title{Quantiles with Replicate Weights}
\usage{
repquant(
  x,
  qtl = c(0.05, 0.25, 0.75, 0.95),
  PV = FALSE,
  setup = NULL,
  repwt,
  wt,
  df,
  method,
  group = NULL,
  by = NULL,
  exclude = NULL
)
}
\arguments{
\item{x}{a string vector specifying variable names (within \code{df}) for
analysis.}

\item{qtl}{a numeric vector indicating the desired quantiles (between 0 and 1).}

\item{PV}{a logical value indicating if the variables in \code{x} are
plausible values.}

\item{setup}{an optional list produced by \code{\link{repsetup}}.}

\item{repwt}{a string indicating the common names for the replicate weights
columns (within \code{df}), or a data frame with the replicate weights.}

\item{wt}{a string specifying the name of the column (within \code{df}) with the
total weights.}

\item{df}{a data frame.}

\item{method}{a string indicating the name of the replication method.
Available options are:
\code{"JK2-full"}, \code{"JK2-half"},
\code{"FAY-0.5"},
and \code{"JK2-half-1PV"}. \cr\cr
Additionally, ILSA names can be used, defaulting into:
\itemize{
\item \code{"TIMSS"} or \code{"PIRLS"} for \code{"JK2-full"};
\item \code{"ICILS"}, \code{"ICCS"}, or \code{"CIVED"} for \code{"JK2-half"};
\item \code{"PISA"} or \code{"TALIS"} for \code{"FAY-0.5"};
\item and \code{"oldTIMSS"} or \code{"oldPIRLS"} for \code{"JK2-half-1PV"}.
}
Note that \code{"oldTIMSS"} and \code{"oldPIRLS"}
refer to the method used for TIMSS and PIRLS before 2015,
where within imputation variance
is estimated using only 1 plausible value.}

\item{group}{a string specifying the variable name (within \code{df}) to be
used for grouping. Categories in \code{group} are treated as independent, e.g.,
countries.}

\item{by}{a string specifying a second variable (within \code{df}) for grouping.
Categories used in \code{by} are not considered independent, e.g., gender
within a country. If used,
the output will be a list with the same length as the  unique values of
\code{by}. This can only be used for analyses with one variable or a group
of PVs.}

\item{exclude}{a vector indicating which groups
(in the same format as \code{group})
should be excluded from the pooled and composite estimates.}
}
\value{
a data frame or a list.
}
\description{
Estimates quantiles with replicate weights
for a variable or a group of variables and for one or more
populations.
For a detailed explanation on how the standard errors are estimated
see \code{\link{repse}}.
}
\examples{

RWT <- repcreate(df = repdata, # the data frame with all the information
                 wt = "wt", # the total weights column name
                 jkzone = "jkzones", # the jkzones column name
                 jkrep = "jkrep", # the jkreps column name
                 repwtname = "REPWT", # the desired name for the rep weights
                 reps = 50, # the number of replications
                 method = "ICILS") # the name of the method aka the study name

### No groups ----

# One variable - weights within df
repquant(x = c("item01"),
        qtl = c(0.05, 0.25, 0.75, 0.95),
        PV = FALSE,
        repwt = "REPWT", wt = "wt", df = cbind(repdata,RWT),
        method = "ICILS")

# One variable - weights as a separate data frame
repquant(x = c("item01"),
        qtl = c(0.05, 0.25, 0.75, 0.95),
        PV = FALSE,
        repwt = RWT, wt = "wt", df = repdata,
        method = "ICILS")

# One PV variable
repquant(x = paste0("Math",1:5),
        qtl = c(0.05, 0.25, 0.75, 0.95),
        PV = TRUE, # if set to TRUE, PVs will be treated as separate variables
        repwt = RWT, wt = "wt", df = repdata,
        method = "ICILS")

### Groups ----

# One variable
repquant(x = c("item01"),
        qtl = c(0.05, 0.25, 0.75, 0.95),
        PV = FALSE,
        repwt = RWT, wt = "wt", df = repdata,
        method = "ICILS",
        group = "GROUP",
        exclude = "GR2") # GR2 will not be used for Pooled nor Composite


# One PV variable
repquant(x = paste0("Math",1:5),
        qtl = c(0.05, 0.25, 0.75, 0.95),
        PV = TRUE, # if set to TRUE, PVs will be treated as separate variables
        repwt = RWT, wt = "wt", df = repdata,
        method = "ICILS",
        group = "GROUP",
        exclude = "GR2") # GR2 will not be used for Pooled nor Composite

### Groups and By ----

# One variable
repquant(x = c("item01"),
        qtl = c(0.05, 0.25, 0.75, 0.95),
        PV = FALSE,
        repwt = RWT, wt = "wt", df = repdata,
        method = "ICILS",
        group = "GROUP",
        by = "GENDER", # results will be separated by GENDER
        exclude = "GR2") # GR2 will not be used for Pooled nor Composite

# One PV variable
repquant(x = paste0("Math",1:5),
        qtl = c(0.05, 0.25, 0.75, 0.95),
        PV = TRUE, # if set to TRUE, PVs will be treated as separate variables
        repwt = RWT, wt = "wt", df = repdata,
        method = "ICILS",
        group = "GROUP",
        by = "GENDER", # results will be separated by GENDER
        exclude = "GR2") # GR2 will not be used for Pooled nor Composite
}
