% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{plotINet}
\alias{plotINet}
\title{plotINet}
\usage{
plotINet(
  adj,
  graph.consensus,
  edge.width = 3,
  vertex.label.cex = 0.5,
  vertex.size = 10,
  edge.curved = 0.2,
  method = "NA",
  ...
)
}
\arguments{
\item{adj}{one of the beginning adjacency matrices}

\item{graph.consensus}{consensus network, output of the
\code{\link{consensusNet}} function}

\item{edge.width}{the edge width (default 3)}

\item{vertex.label.cex}{the size of the vertex label (default 0.8)}

\item{vertex.size}{the size of the vertex (default 10)}

\item{edge.curved}{to make the edge curved (default 0.2)}

\item{method}{community detection method to color the nodes one of "walktrap",
"edgeBetweenness", "fastGreedy", "louvain", "spinglass", "leadingEigen",
"labelProp", "infomap", "optimal" and "leiden" (default no method)}

\item{...}{other parameter}
}
\value{
Union graph beginning and consensus edge coloured, green edges
consensus already present in the beginning, blue edges new of the consensus.
Community detection of the beggining graph if added.
}
\description{
The function plots a beginning network and the consensus in
one graph with different edge colours: red edges represent edges of the
 consensus already present in the beginning one, while light blue edges
 represent new edges constructed from the consensus.
}
\examples{
data("adjL_data")
con <- consensusNet(adjL_data)
plotINet(adjL_data[[1]], con$graphConsensus)
}
