% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dt_gen.R
\name{sim_tsGVAR}
\alias{sim_tsGVAR}
\title{Simulate data for a (multi-group) N = 1 GVAR model}
\usage{
sim_tsGVAR(
  temp_base_ls,
  beta_base_ls,
  cont_base_ls,
  kappa_base_ls,
  n_node,
  n_time = 50,
  n_person,
  save_nets = FALSE
)
}
\arguments{
\item{temp_base_ls}{a list of temporal networks of all individuals}

\item{beta_base_ls}{a list of beta matrices of all individuals}

\item{cont_base_ls}{a list of contemporaneous networks of all individuals}

\item{kappa_base_ls}{a list of precision matricies of all individuals}

\item{n_node}{number of nodes}

\item{n_time}{number of measurements per person, default to 50}

\item{n_person}{number of individuals to generate data for}

\item{save_nets}{a logical value indicating whether to save the data-generating networks, default to FALSE}
}
\value{
A list of temporal and contemporaneous networks
}
\description{
This function generates data for the input (multi-group) N = 1 GVAR model
}
\examples{
library(IVPP)
# Generate the network
net_ls <- gen_tsGVAR(n_node = 6,
                     p_rewire_temp = 0.5,
                     p_rewire_cont = 0,
                     n_persons = 3)

# Generate the data
data <- sim_tsGVAR(beta_base_ls = net_ls$beta,
                   kappa_base_ls = net_ls$kappa,
                   # n_person = 3,
                   n_time = 50)
}
\author{
Xinkai Du
Maintainer: Xinkai Du \href{mailto:xinkai.du.xd@gmail.com}{xinkai.du.xd@gmail.com}
}
