% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankb.R
\name{rankb}
\alias{rankb}
\title{Rank Based Tests for Incomplete Paired Data}

\description{
The function performs testing the hypothesis of equality of means for the incomplete pairs setting data. The function uses a rank-based procedure for parameter estimation and hypothesis testing when the data are a mixture of paired observations and independent samples. The rank-based methods combine Wilcoxon signed-rank statistics and Wilcoxon-Mann-Whitney two-sample procedures. These methods were developed by Dubnicka, Blair and Hettmansperger (2002).
}

\usage{
rankb(xp, yp, xu, yu, mu = NULL, method = "Ranku",
      alternative = "two.sided", verbose = TRUE)
}

\arguments{
\item{xp, yp}{(non-empty) numeric vectors of data values of the the complete pairs}
\item{xu}{a numeric vector of data on x only}
\item{yu}{a numeric vector of data on y only}
\item{mu}{a number indicating the true value of the mean (or difference in means if you are performing a two sample test)}
\item{method}{a character string specifying the different type of methods, must be one of "Ranku" or "Rankw"}
\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater" or "less"}
\item{verbose}{if TRUE, show the test used, null and alternative hypotheses in addition to the p-value}
}

\value{A S4 object containing the following components:
\item{Title}{a character string describing the test used}
\item{Nhypothesis}{a character string describing the null hypothesis}
\item{Ahypothesis}{a character string describing the alternative hypothesis}
\item{Pval}{the p-value for the test}

}

\references{
Dubnicka, S. R., Blair, R. C., & Hettmansperger, T. P. (2002). Rank-based procedures for mixed paired and two-sample designs. Journal of Modern Applied Statistical Methods, 1(1), 6.
}

\examples{
n=20
n1=15
n2=10
r=0.8
xp=rnorm(n)
yp=r*xp+(1-r)*(rnorm(n))
xu=rnorm(n1)
yu=rnorm(n2)
mu=0
rankb(xp,yp,xu,yu,mu,method="Rankw",alternative="two.sided")
}
