% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SelInd.R
\name{SelInd}
\alias{SelInd}
\title{Function to calculate selection index}
\usage{
SelInd(
  w,
  G,
  r2,
  H = NULL,
  i = NULL,
  h2 = NULL,
  d_G_obs = NULL,
  delta = 1e-04,
  verbose = TRUE
)
}
\arguments{
\item{w}{Numeric vector of n economic weights. Traits present in G, but not part of the index need to be coded as 0. If traits of G are missing, they will be added automatically with zero weight. Required.}

\item{G}{Named n*n genetic variance- covariance matrix. Dimnames of G need to match w to ensure correct sorting.  Required.}

\item{r2}{Named numeric vector of reliabilities with length m. Required.}

\item{H}{Named m*m variance-covariance matrix of estimated breeding to internally derive the residual variance-covariance matrix. If H contains more traits than r2, it will be subsetted.}

\item{i}{Selection intensity}

\item{h2}{named numeric vector of length n containing heritabilities for the traits}

\item{d_G_obs}{named numeric vector of length n containing the observed composition of the genetic gain scaled in genetic standard deviations. If sum(d_G_obs) != 1, it will be rescaled.}

\item{delta}{small increment to calculate approximate first derivative}

\item{verbose}{Shall information be printed?}
}
\value{
A list of class SelInd
}
\description{
Function to calculate selection index
}
\details{
The framework allows to have less traits in the selection index than in the breeding goal (m < n). Calculation of realized economic weights, however, requires m == n.
}
\examples{
tn <- c("RZM", "RZN", "RZEo")
G <- matrix(
    c(1.0,0.13,0.13,
    0.13,1.0,0.23,
    0.13,0.23,1.0),
    3, 3, dimnames = list(tn,tn)
    ) * 144
w <- c(0.7, 0.3, 0)
names(w) <- tn
r2 <- c(0.743, 0.673)
names(r2) <- tn[1:2]
SelInd(
  w = w,
  G = G,
  r2 = r2
)

}
