% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Inquilab.R
\name{first_order_kinetics}
\alias{first_order_kinetics}
\title{Calculate First Order Kinetics Parameters}
\usage{
first_order_kinetics(t, c)
}
\arguments{
  \item{t}{Numeric vector, time points.}
  \item{c}{Numeric vector, concentrations corresponding to each time point.}
}
\description{
This function calculates the rate constant, half-life, and provides a summary
of the first-order dissipation kinetics of pesticides, including the intercept,
R^2 value, and statistical measures of the fitted model.
}
\details{
The function performs a logarithmic transformation on the concentration values
to fit a linear model which corresponds to the first-order kinetics equation.
A negative of the slope of this model gives the rate constant, and the half-life
is calculated using the natural logarithm of 2 divided by the rate constant.
}
\examples{
t <- c(0, 5, 10, 15, 20, 25)
c <- c(100, 80, 60, 40, 20, 10)
first_order_kinetics(t, c)
}
\value{
A list containing the following components:
  \item{rate constant}{The calculated rate constant for the first-order kinetics.}
  \item{half life}{The calculated half-life based on the rate constant.}
  \item{summary}{A summary object providing statistical measures of the fitted model, including the intercept, R^2 value, among others.}
}
\seealso{
  \code{\link[stats]{lm}}, for details on the linear models used within.
}
\keyword{models}
\keyword{statistics}

