% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IntervalData.R
\name{IntervalData}
\alias{IntervalData}
\title{Create an \code{IntervalData} object}
\usage{
IntervalData(a1, a2, type = 1)
}
\arguments{
\item{a1}{A single real number specifying either the infimum or either
the mid-point of the interval stored as a unique \code{numeric}
value.}

\item{a2}{A single real number specifying either the supremum or either
the spread of the interval stored as a unique \code{numeric}
value.}

\item{type}{A single real number specifying the characterization that
is being used stored as a unique \code{numeric} value.
Only two options are allowed:
\itemize{
\item \code{1}: The \emph{inf/sup}-characterization
is used (default).
\item \code{2}: The \emph{mid/spr}-characterization is used.
}}
}
\value{
This function returns the created \code{IntervalData} object.
}
\description{
For convenience, \code{IntervalData} objects or instances
may be created with this function.
}
\examples{
## The following code generates the same interval through
## both inf/sup and mid/spr characterizations, respectively.
## In particular, interval [0, 2] = [1 -+ 1] is defined.
i1 <- IntervalData(a1 = 0, a2 = 2, type = 1); i1
i2 <- IntervalData(a1 = 1, a2 = 1, type = 2); i2
}
\seealso{
For other interval-valued data definition use \code{\link{IntervalList}()}
and \code{\link{IntervalMatrix}()} functions.
}
\author{
José García-García \email{garciagarjose@uniovi.es}
}
