% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rectifiedI.R
\name{localICorrection}
\alias{localICorrection}
\title{Scaling process for Local Moran's I.}
\usage{
localICorrection(localI, vI, statsVI, scalingUpTo = "Quantile")
}
\arguments{
\item{localI}{Local Moran's I, It could be computed using calculateLocalMoranI function.}

\item{vI}{the vector obtained by resamplingI.}

\item{statsVI}{the statistic vector obtained from summaryLocalIVector.}

\item{scalingUpTo}{the rescaling could be done up to the 0.01\% and 99.9\% quantile or max and min values. The two possible options are: "MaxMin", or "Quantile". The default value for this parameter is Quantile.}
}
\value{
rescaled local I vector
}
\description{
\code{localICorrection} . consists in centering the local I value (I-median) and scaling by the difference between the median and 1st or 99th quantile. The correction is according to the following equation:
\deqn{
I = \left\{
\begin{array}{lr}
\frac{(I-median)}{(median - Q1)}& I < median\\
\frac{(I-median)}{(Q99-median)}& I>median\\
\end{array}\right\}
}
}
\examples{
inputFileName<-system.file("testdata", "chen.csv", package="Irescale")
input<-loadFile(inputFileName)
distM<-calculateEuclideanDistance(input$data)
localI <- calculateLocalI(input$varOfInterest,distM)
vI<-resamplingLocalI(input$varOfInterest,distM)
statsVI<-summaryLocalIVector(vI)
corrections<-localICorrection(localI,vI,scalingUpTo="Quantile")
}
