% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/character_est.ss.R
\name{est.ss}
\alias{est.ss}
\title{est.ss}
\usage{
est.ss(
  abstract = NULL,
  text = NULL,
  stats = NULL,
  standardStats = NULL,
  quantileDF = 0.9,
  max.only = FALSE,
  max.parts = TRUE
)
}
\arguments{
\item{abstract}{an abstract text string.}

\item{text}{the main text string to process (usually method and result sections). If text has content, arguments "stats" and "standardStats" are deactivated and filled with results by get.stats(text).}

\item{stats}{statistics extracted with get.stats(x)$stats (only active if no text is submitted).}

\item{standardStats}{standard statistics extracted with get.stats(x)$standardStats  (only active if no text is submitted).}

\item{quantileDF}{quantile of (df1-1)+(df2+2) to extract.}

\item{max.only}{Logical. If TRUE only the final estimate will be returned, if FALSE all sub estimates are returned as well.}

\item{max.parts}{Logical. If FALSE outputs all captured sample sizes in sub inputs.}
}
\value{
Numeric vector with extracted sample sizes by input and estimated sample size.
}
\description{
Function to estimate studies sample size by maximizing different conservative estimates.
Performs four different extraction heuristics for sample sizes mentioned in abstract, text and statistical results.
}
\details{
Sample size extraction from abstract:\cr
- Extracts N= from abstract text and performs position-of-speech search with list of synonyms of sample units

Sample size extraction from text:\cr
- Unifies and extracts textlines with age descriptions, than computes sum of hits as nage
- Unifies and extracts all "numeric male-female" patterns than computes sum of first male/female hit
- Unifies and extracts textlines with participant description than computes sum of first three hits as ntext

Sample size extraction from statistical results:\cr
- Extracts "N=" in statistical results extracted with allStats() that contain p-value: e.g.: chi(2, N=12)=15.2, p<.05

Sample size extraction by degrees of freedom with result of standardStats(allStats()):\cr
- Extracts df1 and df2 if possible and neither containing a ".", than calculates specified quantile of (df1+1)+(df2+2) (at least 2 group comparison assumed)
}
\examples{
\donttest{
 a<-"One hundred twelve students participated in our study."
 est.ss(abstract=a)
 x<-"Our sample consists of three hundred twenty five undergraduate students.
     The F-test indicates significant differences in means F(2,102)=3.21, p<.05."
 est.ss(text=x)
}
}
\seealso{
\code{\link[JATSdecoder]{study.character}} for extracting multiple study characteristics at once.
}
