% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jmrmlB.R
\name{jmrmlB}
\alias{jmrmlB}
\title{Joint model for Bidirectional survival data using \code{joineRML}}
\usage{
jmrmlB(
  dtlong,
  dtsurv,
  longm,
  survm,
  rd,
  timeVar,
  id,
  samplesize = 200,
  BIGdata = FALSE
)
}
\arguments{
\item{dtlong}{longitudinal data}

\item{dtsurv}{survival data with two event status along with event time}

\item{longm}{longitudinal model e.g. list(serBilir~drug * year,serBilir ~ drug * year)}

\item{survm}{survival model e.g. list(Surv(years,status2)~drug,Surv(time_2,status_2)~drug+age)}

\item{rd}{random effect component e.g. list(~year|id,~year|id)}

\item{timeVar}{time variable}

\item{id}{ID variable}

\item{samplesize}{samplesize for bigdata}

\item{BIGdata}{logical argument TRUE or FALSE}
}
\value{
Estimated model parameters of Joint model with bidirectional survival data
}
\description{
The function fits joint model for survival data with two events. It utilizes the joineRML package for obtaining the model parameter estimates.
}
\examples{
 \donttest{
##
library(JMbayes2)
library(joineRML)
jmrmlBModel<-jmrmlB(dtlong=new_long2[new_long2$id\%in\%c(1:80),],
                    dtsurv=new_surv2[new_surv2$id\%in\%c(1:80),],
                    longm=list(y~x7+visit,y~x7+visit),survm=list(Surv(time,status)~x1+visit,
                    Surv(time_2,status_2)~x1+visit),rd=list(~visit|id,~visit|id),id='id',
                    timeVar='visit',samplesize=40,BIGdata=TRUE)
jmrmlBModel
##
}
}
\references{
Hickey, Graeme L., et al. "joineRML: a joint model and software package for time-to-event and multivariate longitudinal outcomes." BMC medical research methodology 18 (2018): 1-14.

Bhattacharjee, A., Rajbongshi, B. K., & Vishwakarma, G. K. (2024). jmBIG: enhancing dynamic risk prediction and personalized medicine through joint modeling of longitudinal and survival data in big routinely collected data. BMC Medical Research Methodology, 24(1), 172.
}
\author{
Atanu Bhattacharjee, Bhrigu Kumar Rajbongshi and Gajendra Kumar Vishwakarma
}
