% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hist2dsm.R
\name{hist2dsm}
\alias{hist2dsm}
\title{Smooth a 2D histogram}
\usage{
hist2dsm(
  Y,
  nsegx = 10,
  nsegy = nsegx,
  bdeg = 3,
  lambdax = 10,
  lambday = lambdax,
  dx = 3,
  dy = dx,
  Mu = Y + 0.01,
  kappa = 1e-04,
  tol = 1e-05
)
}
\arguments{
\item{Y}{a matrix of counts.}

\item{nsegx}{the number of knots along \code{x} (default=10).}

\item{nsegy}{the number of evenly spaced knots along \code{y} for Tensor product B-spline basis (default=10).}

\item{bdeg}{the degree of the basis, default is 3.}

\item{lambdax}{the positive number for the tuning parameter along \code{x}.}

\item{lambday}{the positive number for the tuning parameter along \code{y}.}

\item{dx}{the order of the difference penalty along \code{x}, default is 3.}

\item{dy}{the order of the difference penalty along \code{y}, default is 3.}

\item{Mu}{the initialization of the mean (default \code{Y + 0.01}).}

\item{kappa}{a (small, positive) number for ridge tuning parameter to stabilize estimation (default \code{1e-4}).}

\item{tol}{the convergence criterion (default \code{1e-5}).}
}
\value{
A list with elements:
\item{ed}{the effective dimension of the smooth 2D surface.}
\item{Mu}{a matrix with the smooth estimates, with dimensions of \code{dim(Y)}}
\item{pen}{the numerical value of the penalty.}
}
\description{
Fit a 2D smooth P-spline surface to a matrix of counts, assuming Poisson distributed observations.
}
\examples{
x = faithful$eruptions
y = faithful$waiting
h = hist2d(x, y, c(100, 100))
sm = hist2dsm(h$H, nsegx = 25, nsegy = 25, bdeg = 3, lambdax = 10, lambday = 10)
image(h$xgrid, h$ygrid, sm$Mu, xlab = 'Eruption length (min)',
      ylab = 'Waiting time (min)', main = 'Old Faithful')

}
\references{
Eilers, P.H.C., Marx, B.D., and Durban, M. (2015).
Twenty years of P-splines, \emph{SORT}, 39(2): 149-186.

Eilers, P.H.C. and Marx, B.D. (2021). \emph{Practical Smoothing, The Joys of
P-splines.} Cambridge University Press.
}
\author{
Paul Eilers
}
