% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaya_multi.R
\name{jaya_multi}
\alias{jaya_multi}
\title{Jaya Algorithm for Multi-Objective Optimization}
\usage{
jaya_multi(
  objectives,
  lower,
  upper,
  popSize = 50,
  maxiter,
  n_var,
  seed = NULL,
  suggestions = data.frame(),
  constraints = list(),
  adaptive_pop = FALSE,
  min_popSize = 20,
  max_popSize = 100,
  early_stopping = FALSE,
  tolerance = 1e-06,
  patience = 10
)
}
\arguments{
\item{objectives}{A list of objective functions to optimize.}

\item{lower}{Numeric vector specifying the lower bounds for variables.}

\item{upper}{Numeric vector specifying the upper bounds for variables.}

\item{popSize}{Population size. Default is 50.}

\item{maxiter}{Maximum number of iterations.}

\item{n_var}{Number of variables.}

\item{seed}{Random seed for reproducibility. Default is `NULL`.}

\item{suggestions}{Data frame of initial suggestions for starting population. Default is an empty data frame.}

\item{constraints}{A list of constraint functions. Each constraint should return a non-positive value if satisfied.}

\item{adaptive_pop}{Logical. Whether to adapt population size during optimization. Default is `FALSE`.}

\item{min_popSize}{Minimum population size if adaptive population is enabled. Default is 20.}

\item{max_popSize}{Maximum population size if adaptive population is enabled. Default is 100.}

\item{early_stopping}{Logical. Whether to stop early if no improvement is observed. Default is `FALSE`.}

\item{tolerance}{Numeric tolerance for early stopping. Default is 1e-6.}

\item{patience}{Number of iterations to wait for improvement before stopping. Default is 10.}
}
\value{
A list containing:
- `Pareto_Front`: A data frame of non-dominated solutions with decision variables and their corresponding objective values.
- `Solutions`: The final population including decision variables and their objective values.
}
\description{
Implements the Jaya optimization algorithm for multi-objective optimization.
This algorithm supports non-dominated sorting and handles constraints and adaptive population sizes.
}
\examples{
# Example: Multi-objective optimization
sphere_function_1 <- function(x) sum(x^2)
sphere_function_2 <- function(x) sum((x - 2)^2)
result <- jaya_multi(
  objectives = list(sphere_function_1, sphere_function_2),
  lower = rep(-5, 3),
  upper = rep(5, 3),
  popSize = 20,
  maxiter = 50,
  n_var = 3
)
print(summary(result))

}
