% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.jaya}
\alias{summary.jaya}
\title{Summary Method for Jaya Algorithm Optimization Results}
\usage{
\method{summary}{jaya}(object, ...)
}
\arguments{
\item{object}{An object of class \code{jaya} or \code{jaya_multi}, containing the results of the Jaya optimization.}

\item{...}{Additional arguments (currently unused).}
}
\description{
Provides a summary of optimization results for both single-objective
and multi-objective cases. Displays key parameters, limits, and results such as
the best solution for single-objective optimization or the Pareto front for multi-objective optimization.
}
\details{
- For single-objective optimization, the summary includes the best solution and the associated function value.
- For multi-objective optimization, the summary displays the objectives, decision variable limits,
and the first few entries of the Pareto front.
- Automatically handles missing or incomplete attributes gracefully.
}
\examples{
# Single-objective optimization example
sphere_function <- function(x) sum(x^2)
single_result <- jaya(
  fun = sphere_function,
  lower = c(-5, -5, -5),
  upper = c(5, 5, 5),
  popSize = 20,
  maxiter = 50,
  n_var = 3,
  opt = "minimize"
)
summary(single_result)

# Multi-objective optimization example
objective1 <- function(x) sum(x^2)
objective2 <- function(x) sum(abs(x))
multi_result <- jaya_multi(
  objectives = list(objective1, objective2),
  lower = c(-5, -5, -5),
  upper = c(5, 5, 5),
  popSize = 50,
  maxiter = 100,
  n_var = 3
)
summary(multi_result)

}
