#' @keywords internal
"_PACKAGE"


#' Provides an implementation of a kernel-embedding of probability test for
#' elliptical distribution. This is an asymptotic test for elliptical
#' distribution under general alternatives, and the location and shape
#' parameters are assumed to be unknown. Some side-products are posted,
#' including the transformation between rectangular and polar coordinates and
#' two product-type kernel functions.
#'
#'
#'
#'
#' @author
#' Yin Tang \email{yqt5219@@psu.edu}
#' Bing Li \email{bxl9@@psu.edu}
#'
#' @name KEPTED
#'
#' @references
#' \cite{Tang, Y. and Li, B. (2024), “A nonparametric test for elliptical
#' distribution based on kernel embedding of probabilities,”
#' \url{https://arxiv.org/abs/2306.10594}}
#'
#' @import expm
#' @import cubature
#' @import CompQuadForm
#' @import stats
#'
#'
## usethis namespace: start
## usethis namespace: end
NULL
