% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{halfsib}
\alias{halfsib}
\title{Dataset for a case involving a putative half sibling.}
\format{
A list of two ped objects, named H1 and H2.
}
\usage{
halfsib
}
\description{
A list of two pedigrees forming opposing hypotheses about three individuals:
}
\details{
\itemize{
\item H1: A and B are full siblings, and C is their half brother
\item H2: A and B are full siblings, and C is unrelated to them
}

The individuals are typed with 50 markers, but some genotypes are missing.
}
\examples{
library(pedtools)
plotPedList(halfsib, hatched = typedMembers)
markerSummary(halfsib)
linkedLR(halfsib)
}
\keyword{datasets}
