% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{keybd.press}
\alias{keybd.press}
\title{Simulate Key Press}
\usage{
keybd.press(button, hold = FALSE)
}
\arguments{
\item{button}{character. The key press to simulate (not case sensitive).}

\item{hold}{logical. Whether the key should be held down. If \code{TRUE}, the key can
be released by pressing the phsical key on the keyboard or by using the \code{\link[KeyboardSimulator]{keybd.release}} function.}
}
\description{
Simulate keyboard key presses. Multiple keys can be pressed simultaneously by using \code{+} as separator (see Examples). See \code{\link[KeyboardSimulator]{keyboard_value}} for supported keys.
}
\examples{
\dontrun{

# press one key
keybd.press("a")

# press multiple keys
keybd.press("Alt+F4")

# press multiple keys using hold
keybd.press("Alt", hold = TRUE)
keybd.press("F4")
keybd.release("Alt")
}
}
\seealso{
\code{\link[KeyboardSimulator]{keybd.release}}
}
