% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pedigree.r
\name{score.pedigree}
\alias{score.pedigree}
\title{Take the encoded information about the pedigrees and calculate penetrance.}
\usage{
score.pedigree(h)
}
\arguments{
\item{h}{A data frame containing the encoded pedigree information}
}
\value{
A data frame containing the theoretical scoring of the power of a
family assuming you were able to collect everyone on the simplified pedigree,
as well as a current scoreing, examining only those for whom you currently
have DNA.
}
\description{
Determine a value score of families by comparing their relationship structure.
More distant relationships between affecteds (e.g. affected cousins)
is more valuable that close relationships (e.g. affected siblings)
as there is less IBD and therefore a smaller search space.
}
\details{
Simplifying assumptions:
\itemize{
\item Autosomal dominant
\item No ambiguous statuses
\item No more than two sequential generations of unknown carrier status
(non-obligate carrier vs. non-carrier).
Generalized support of arbitrary tree structures gets a lot more
complicated, especially for the likelihood function.
\item Exclude big giant trees of unaffecteds - related to above.
Will slightly bias the result toward higher penetrance.
\item Exclude subjects younger than age of onset
}
}
\examples{
example.pedigree.file <-system.file('extdata/example_pedigree_encoding.tsv',
package = 'KinformR')
example.pedigree.df <- read.pedigree(example.pedigree.file)
penetrance.df <- score.pedigree(example.pedigree.df)
}
