% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_functions.R
\name{sim_hdchange_no_nbd}
\alias{sim_hdchange_no_nbd}
\title{Simulate data without neighbourhood}
\usage{
sim_hdchange_no_nbd(
  n = 200,
  p = 30,
  S = 30,
  tau = c(40, 100, 160),
  dist_info = list(dist = "normal", dependence = "iid", param = 1),
  jump_max = c(2, 2, 1.5)
)
}
\arguments{
\item{n}{Number of time series observations.}

\item{p}{Number of individuals.}

\item{S}{Number of individuals with jumps.}

\item{tau}{An array of length \eqn{K} for time stamps for breaks.}

\item{dist_info}{A list specifying the distribution of the innovation.}

\item{jump_max}{An array of length \eqn{K} for jump sizes of the breaks.}
}
\value{
A \eqn{p \times n} simulated data matrix.
}
\description{
Simulate data without neighbourhood
}
\details{
'dist_info' should be a list containing the following items:
\itemize{

\item dist: distribution of the innovations, either "normal" or "t".

\item dependence: iid or MA(\eqn{\infty}), either "iid" or "MA_inf".

\item param = parameter of the distribution, standard deviation for normal distribution
and degree of freedom for t distribution

}
See \code{\link[=ts_hdchange]{ts_hdchange()}} for example.
}
\examples{
data_no_nbd <- sim_hdchange_no_nbd(n = 200,
p = 30,
S = 30,
tau = c(40, 100, 160),
dist_info =
  list(dist = "normal", dependence = "MA_inf", param = 1),
jump_max = c(2, 2, 1.5))


}
