% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_functions.R
\name{test_existence}
\alias{test_existence}
\title{Test the existence of change-points in the data}
\usage{
test_existence(hdobj, display = TRUE)
}
\arguments{
\item{hdobj}{An S3 object of class 'no_nbd' or 'nbd' generated
by \code{\link[=ts_hdchange]{ts_hdchange()}}.}

\item{display}{A logical. If 'display = TRUE', the test statistics and
critical values will be printed.}
}
\value{
A list containing the following elements:
\itemize{

\item 'test_stats' The test statistics
\eqn{\mathcal{\boldsymbol{Q}}_{n}}.

\item 'critical_values' The critical values.

\item 'stat_all' An array of \eqn{|V_{i}|_{2}^{2}}.

\item 'critical_value_alpha' The threshold value \eqn{\omega} depending on alpha.

}
}
\description{
Test the existence of change-points in the data
}
\details{
See \code{\link[=hdchange]{hdchange()}} for examples.
}
\examples{
# generate data
data_no_nbd <- sim_hdchange_no_nbd(n = 200,
p = 30,
S = 30,
tau = c(40, 100, 160),
dist_info =
  list(dist = "normal", dependence = "MA_inf", param = 1),
jump_max = c(2, 2, 1.5))

# construct no_nbd object
ts_no_nbd <- ts_hdchange(data_no_nbd,
window_size = 30,
m = 8,
h = 1,
N_rep = 999,
alpha = 1e-5,
quantiles = c(0.01, 0.05, 0.1))

test <- test_existence(ts_no_nbd, display = TRUE)

}
\references{
Li, J., Chen, L., Wang, W. and Wu, W.B., 2022. \eqn{\ell^2} Inference for Change Points in High-Dimensional Time Series via a Two-Way MOSUM.
\emph{arXiv preprint arXiv:2208.13074}.
}
