% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_optimalization.R
\name{abc_model_opt}
\alias{abc_model_opt}
\title{Optimize ABC model calculations for large matrices}
\usage{
abc_model_opt(
  co_matrix,
  a_term,
  c_term = NULL,
  min_score = 0.1,
  n_results = 100,
  chunk_size = 500
)
}
\arguments{
\item{co_matrix}{A co-occurrence matrix produced by create_cooccurrence_matrix().}

\item{a_term}{Character string, the source term (A).}

\item{c_term}{Character string, the target term (C). If NULL, all potential C terms will be evaluated.}

\item{min_score}{Minimum score threshold for results.}

\item{n_results}{Maximum number of results to return.}

\item{chunk_size}{Number of B terms to process in each chunk.}
}
\value{
A data frame with ranked discovery results.
}
\description{
This function implements an optimized version of the ABC model calculation
that's more efficient for large co-occurrence matrices.
}
