% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3update.R
\name{update}
\alias{update}
\alias{update.LCA}
\alias{update.LPA}
\alias{update.LCPA}
\alias{update.LTA}
\alias{update.sim.LCA}
\alias{update.sim.LPA}
\alias{update.sim.LTA}
\title{S3 Methods: update}
\usage{
update(x, ...)

\method{update}{LCA}(x, ...)

\method{update}{LPA}(x, ...)

\method{update}{LCPA}(x, ...)

\method{update}{LTA}(x, ...)

\method{update}{sim.LCA}(x, ...)

\method{update}{sim.LPA}(x, ...)

\method{update}{sim.LTA}(x, ...)
}
\arguments{
\item{x}{An object of one of the following classes:
\itemize{
\item \code{\link[LCPA]{LCA}} — Latent Class Analysis model.
\item \code{\link[LCPA]{LPA}} — Latent Profile Analysis model.
\item \code{\link[LCPA]{LCPA}} — Latent Class Prediction Analysis (with covariates).
\item \code{\link[LCPA]{LTA}} — Latent Transition Analysis model.
\item \code{\link[LCPA]{sim.LCA}} — Simulated LCA dataset.
\item \code{\link[LCPA]{sim.LPA}} — Simulated LPA dataset.
\item \code{\link[LCPA]{sim.LTA}} — Simulated LTA dataset.
}}

\item{...}{Additional named arguments passed to override or extend the original call.
Valid arguments depend on the class of \code{x}:
\describe{
\item{\strong{\code{LCA}}}{\code{response}, \code{L}, \code{par.ini}, \code{method},
\code{is.sort}, \code{nrep}, \code{vis}, \code{control.EM}, \code{control.Mplus}, \code{control.NNE}}
\item{\strong{\code{LPA}}}{\code{response}, \code{L}, \code{par.ini}, \code{constraint},
\code{method}, \code{is.sort}, \code{nrep}, \code{vis}, \code{control.EM}, \code{control.Mplus}, \code{control.NNE}}
\item{\strong{\code{LCPA}}}{\code{response}, \code{L}, \code{ref.class}, \code{type}, \code{covariates},
\code{CEP.error}, \code{par.ini}, \code{params}, \code{is.sort}, \code{constraint}, \code{method},
\code{tol}, \code{maxiter}, \code{nrep}, \code{starts}, \code{maxiter.wa}, \code{vis},
\code{control.EM}, \code{control.Mplus}, \code{control.NNE}}
\item{\strong{\code{LTA}}}{\code{responses}, \code{L}, \code{ref.class}, \code{type}, \code{covariates},
\code{CEP.timeCross}, \code{CEP.error}, \code{covariates.timeCross}, \code{par.ini}, \code{params},
\code{is.sort}, \code{constraint}, \code{method}, \code{tol}, \code{maxiter}, \code{nrep}, \code{starts},
\code{maxiter.wa}, \code{vis}, \code{control.EM}, \code{control.Mplus}, \code{control.NNE}}
\item{\strong{\code{sim.LCA}}}{\code{N}, \code{I}, \code{L}, \code{poly.value}, \code{IQ},
\code{distribution}, \code{params}, \code{is.sort}}
\item{\strong{\code{sim.LPA}}}{\code{N}, \code{I}, \code{L}, \code{constraint}, \code{distribution},
\code{mean.range}, \code{covs.range}, \code{params}, \code{is.sort}}
\item{\strong{\code{sim.LTA}}}{\code{N}, \code{I}, \code{L}, \code{times}, \code{type}, \code{rate},
\code{constraint}, \code{distribution}, \code{mean.range}, \code{covs.range}, \code{poly.value},
\code{IQ}, \code{covariates}, \code{beta}, \code{gamma}, \code{params}, \code{is.sort}}
}}
}
\value{
An object of the same class as \code{x}, reconstructed using the original arguments
updated with any provided in \code{...}. All unchanged parameters are preserved from the original call.
}
\description{
The \code{update} function provides a unified and convenient interface to refresh or modify
existing objects generated by the \code{LCPA} package. It allows users to re-run model fitting
or data simulation with new parameter settings while preserving all other original configurations.
Supported classes include: \code{\link[LCPA]{LCA}}, \code{\link[LCPA]{LPA}},
\code{\link[LCPA]{LCPA}}, \code{\link[LCPA]{LTA}}, \code{\link[LCPA]{sim.LCA}},
\code{\link[LCPA]{sim.LPA}}, and \code{\link[LCPA]{sim.LTA}}.
}
\details{
Internally, each method extracts the stored \code{arguments} list from the input object \code{x},
merges it with user-provided \code{...} using \code{\link[utils]{modifyList}}, then re-invokes
the corresponding constructor function (\code{LCA()}, \code{LPA()}, \code{LCPA()}, \code{LTA()},
\code{sim.LCA()}, etc.) with the merged argument list.

This ensures that:
\itemize{
\item Only explicitly overridden parameters are changed.
\item Default values from the original call remain intact.
\item Complex nested structures (e.g., control lists) can be partially updated.
}

Note: If an invalid argument is passed (e.g., \code{constraint} to \code{LCA}), it will be silently ignored
unless the underlying constructor validates inputs.
}
\section{Methods (by class)}{
\itemize{
\item \code{update(LCA)}: Update method for \code{LCA} objects

\item \code{update(LPA)}: Update method for \code{LPA} objects

\item \code{update(LCPA)}: Update method for \code{LCPA} objects

\item \code{update(LTA)}: Update method for \code{LTA} objects

\item \code{update(sim.LCA)}: Update method for \code{sim.LCA} objects

\item \code{update(sim.LPA)}: Update method for \code{sim.LPA} objects

\item \code{update(sim.LTA)}: Update method for \code{sim.LTA} objects

}}
\examples{
\donttest{
library(LCPA)

# --- Update LCA ---
data <- sim.LCA(N=500, I=5, L=3)
lca.obj <- LCA(data$response, L=3)
lca.updated <- update(lca.obj, method="EM", nrep=5)

# --- Update LPA ---
data2 <- sim.LPA(N=300, I=4, L=2)
lpa.obj <- LPA(data2$response, L=2, constraint="VE")
lpa.updated <- update(lpa.obj, constraint="VV")

# --- Update Simulation Objects ---
sim.obj1 <- sim.LCA(N=1000)
sim.obj1_updated <- update(sim.obj1, N=2000, IQ=0.8)

sim.obj2 <- sim.LPA(I=6)
sim.obj2_updated <- update(sim.obj2, I=8, mean.range=c(-2,2))

sim.obj3 <- sim.LTA(N=200, I=5, L=2, times=3)
sim.obj3_updated <- update(sim.obj3, N=300, times=4, constraint="ER")
}

}
