% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.Treee}
\alias{plot.Treee}
\title{Plot a Treee Object}
\usage{
\method{plot}{Treee}(x, datX, response, node = -1, ...)
}
\arguments{
\item{x}{A fitted model object of class \code{Treee}, typically the result of the
\code{\link[=Treee]{Treee()}} function.}

\item{datX}{A data frame of predictor variables. Required for plotting
individual nodes.}

\item{response}{A vector of response values. Required for plotting individual
nodes.}

\item{node}{An integer specifying the node to plot. If \code{node = -1}, the
entire tree is plotted. Default is \code{-1}.}

\item{...}{Additional arguments passed to the plotting functions.}
}
\value{
A \code{visNetwork} interactive plot of the decision tree if \code{node = -1},
or a \code{ggplot2} object if a specific node is plotted.
}
\description{
This function visualizes either the entire decision tree or a specific node
within the tree. The tree is displayed as an interactive network of nodes and
edges, while individual nodes are scatter/density plots using \code{ggplot2}.
}
\section{Overall Tree Structure}{


A full tree diagram is displayed using \link[visNetwork]{visNetwork} when \code{node} is not
specified (the default is \code{-1}). The color represents the most common
(plurality) class within each node, and the size of each terminal node
reflects its relative sample size. Below each node, the fraction of
correctly predicted training samples and the total sample size for that
node are shown, along with the node index. Clicking on a node opens an
information panel with additional details.
}

\section{Individual Node Plot}{


To plot a specific node, you must provide the node index along with the
original training predictors (\code{datX}) and responses (\code{response}). A scatter
plot is generated if more than one discriminant score is available,
otherwise, a density plot is created. Samples are projected onto their
linear discriminant score(s).
}

\examples{
fit <- Treee(datX = iris[, -5], response = iris[, 5], verbose = FALSE)
plot(fit) # plot the overall tree
plot(fit, datX = iris, response = iris[, 5], node = 1) # plot a specific node
}
