% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llm.predict.R
\name{predict.llm}
\alias{predict.llm}
\title{Create Logit Leaf Model Prediction}
\usage{
\method{predict}{llm}(object, X, ...)
}
\arguments{
\item{object}{An object of class logitleafmodel, as that created by the function llm.}

\item{X}{Dataframe containing numerical independent variables.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
Returns a dataframe containing a probablity for every instance based on the LLM model. Optional rownumbers can be added.
}
\description{
This function creates a prediction for an object of class logitleafmodel. It assumes a dataframe with numeric
values as input and an object of class logitleafmodel, which is the result of the \code{\link{llm}} function.
Currently only binary classification is supported.
}
\examples{
## Load PimaIndiansDiabetes dataset from mlbench package
if (requireNamespace("mlbench", quietly = TRUE)) {
  library("mlbench")
}
data("PimaIndiansDiabetes")
## Split in training and test (2/3 - 1/3)
idtrain <- c(sample(1:768,512))
PimaTrain <-PimaIndiansDiabetes[idtrain,]
Pimatest <-PimaIndiansDiabetes[-idtrain,]
## Create the LLM
Pima.llm <- llm(X = PimaTrain[,-c(9)],Y = PimaTrain$diabetes,
 threshold_pruning = 0.25,nbr_obs_leaf = 100)
## Use the model on the test dataset to make a prediction
PimaPrediction <- predict.llm(object = Pima.llm, X = Pimatest[,-c(9)])
## Optionally add the dependent to calculate performance statistics such as AUC
# PimaPrediction <- cbind(PimaPrediction, "diabetes" = Pimatest[,"diabetes"])
}
\references{
Arno De Caigny, Kristof Coussement, Koen W. De Bock, A New Hybrid Classification Algorithm for Customer Churn Prediction Based on Logistic Regression and Decision Trees, European Journal of Operational Research (2018), doi: 10.1016/j.ejor.2018.02.009.
}
\seealso{
\code{\link{llm}}, \code{\link{table.llm.html}}, \code{\link{llm.cv}}
}
\author{
Arno De Caigny, \email{a.de-caigny@ieseg.fr}, Kristof Coussement, \email{k.coussement@ieseg.fr} and Koen W. De Bock, \email{kdebock@audencia.com}
}
