% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc-data.R
\docType{data}
\name{gastricbypassW}
\alias{gastricbypassW}
\title{Data From The Gastric Bypass Study (Wide Format)}
\usage{
data(gastricbypassW)
}
\description{
Data from the gastric bypass study
where the bodyweight and serum glucagon (a gut hormone) were measured in 20 obese subjects prior and after gastric bypass surgery.
This dataset is in the wide format (i.e. one line per patient).

\itemize{
\item \code{id}: patient identifier.
\item \code{weight1}: bodyweight (in kg) 3 months before surgery.
\item \code{weight2}: bodyweight (in kg) 1 week before surgery.
\item \code{weight3}: bodyweight (in kg) 1 week after surgery.
\item \code{weight4}: bodyweight (in kg) 3 months after surgery.
\item \code{glucagonAUC1}: glucagon  (in pmol/l x hours) 3 months before surgery.
\item \code{glucagonAUC2}: glucagon  (in pmol/l x hours) 1 week before surgery.
\item \code{glucagonAUC3}: glucagon  (in pmol/l x hours) 1 week after surgery.
\item \code{glucagonAUC4}: glucagon  (in pmol/l x hours) 3 months after surgery.
}
}
\references{
The effect of Roux-en-Y gastric bypass surgery on the gut mucosal gene expression profile and circulating gut hormones. \url{https://easddistribute.m-anage.com/from.storage?image=4iBH9mRQm1kfeEHULC2CxovdlyCtA1EHeVDdoffnZrAUGG9SHTO-U4ItnLU078eVkF1ZUZgYTy7THlTW3KSgFA2}
}
\keyword{datasets}
