% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registration.R
\name{jrmpc}
\alias{jrmpc}
\title{jrmpc}
\usage{
jrmpc(
  V,
  C = NULL,
  K = NULL,
  g = NULL,
  initialPriors = NULL,
  updatePriors = TRUE,
  maxIter = 100,
  fixedVarIter = 0,
  tol = 0.01,
  initializeBy = NULL,
  model.selection = FALSE,
  model.selection.threshold = NULL,
  rotation.only = FALSE
)
}
\arguments{
\item{V}{list of point sets as N x D matrices}

\item{C}{(optional) list of arrays of covariance matrices with C[[j]][,,i] the covariance matrix associated with point i of set j.}

\item{K}{(optional) number of components of the GMM, defaults to the average number of points in a set.}

\item{g}{(optional) proportion of noisy points, defaults to 1/K. If set, priors will be initialized uniformly.}

\item{initialPriors}{(optional) vector of length K of prior probabilities. Defaults to uniform distribution using g.
If set, will determine g so it is an error to specify g with initialPriors.}

\item{updatePriors}{logical, whether to update priors at each iteration (default: TRUE).}

\item{maxIter}{maximum number of iterations to perform (default: 100).}

\item{fixedVarIter}{number of iterations before starting variance updates}

\item{tol}{tolerance for determining convergence (default: 1e-2).}

\item{initializeBy}{(optional) how to initialize the GMM means. Defaults to distributing the means on the surface of the sphere enclosing all (centred) sets.
                    Currently supported values are:
                    \itemize{
                     \item 'sampling': sample from the data,
                     \item a K x D matrix of points
}}

\item{model.selection}{whether to perform model selection (default: FALSE). 
If set to TRUE, GMM components with no support in the data are deleted.}

\item{model.selection.threshold}{value below which we consider a GMM component has no support, set to 1/K if not explicitly given}

\item{rotation.only}{if set to TRUE, no translation is performed (default: FALSE)}
}
\value{
a list of 
\itemize{
    \item Y: list of transformed point sets as N x d matrices,
    \item R: list of d x d rotation matrices, one for each point set in V,
    \item t: list of translation vectors, one for each point set in V,
    \item M: centres of the GMM,
    \item S: variances of the GMM.
    \item a: list of posterior probabilities as N x K matrices
    \item iter: number of iterations
    \item conv: error value used to evaluate convergence relative to tol
    \item z: support scores of the GMM components
}
}
\description{
Joint registration of multiple point sets
See: G.  D.  Evangelidis,  D.  Kounades-Bastian,  R.  Horaud,  andE. Z. Psarakis. 
A generative model for the joint registration of multiple point sets. 
In European Conference on Computer Vision, pages 109–122. Springer, 2014
}
\examples{
X <- read.csv(system.file("test_data", "parasaurolophusA.txt", package="LOMAR",
 mustWork = TRUE), sep = "\t")
Y <- read.csv(system.file("test_data", "parasaurolophusB.txt", package="LOMAR",
mustWork = TRUE), sep = "\t")
Z <- read.csv(system.file("test_data", "parasaurolophusC.txt", package="LOMAR",
mustWork = TRUE), sep = "\t")
PS <- list(X, Y, Z)
C <- list()
for(i in 1:3) {
 cv <- diag(0.1, ncol(PS[[i]])) + jitter(0.01, amount = 0.01)
 cv <- replicate(nrow(PS[[i]]), cv)
 C[[i]] <- cv
}
transformation <- jrmpc(PS, C = C, K = 100, maxIter = 20, tol = 0.01, 
model.selection = TRUE)
\dontrun{
# Visualize registration outcome
library(rgl)
colours <- c("blue", "green", "magenta")
Yt <- transformation[['Y']]
plot3d(Yt[[1]], col = colours[1])
for(i in 2:length(Yt)) {
 points3d(Yt[[i]], col = colours[i])
}
# Visualize GMM centres highlighting those with high variance
GMM <- as.data.frame(cbind(transformation[['M']], transformation[['S']]))
colnames(GMM) <- c("x", "y", "z", "S")
colours <- rep("blue", nrow(GMM))
# Find high variance components
threshold <- quantile(transformation[['S']], 0.75)
high.var.idx <- which(transformation[['S']]>threshold)
colours[high.var.idx] <- "red"
plot3d(GMM[, c("x", "y", "z")], col = colours, type = 's', size = 2, box = FALSE, xlab = '', 
      ylab = '', zlab = '', xlim = c(-0.15,0.15), ylim = c(-0.15, 0.15), 
      zlim = c(-0.15, 0.15))
}
}
