% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LPBkg.R
\name{dhatL2}
\alias{dhatL2}
\title{CD-plot and adjusted deviance test}
\description{
Construction of CD-plot and adjusted deviance test. The confidence bands are also adjusted for post-selection inference.
}

\usage{
dhatL2(data, g, M = 6, Mmax = NULL, smooth = TRUE,
  criterion = "AIC", hist.u = TRUE, breaks = 20, ylim = c(0, 2.5),
  range = c(min(data),max(data)), sigma = 2)
}


\arguments{
\item{data}{A vector of data. See details.}

\item{g}{The postulated model from which we want to assess if deviations occur.}

\item{M}{The desired size of the polynomial basis to be used.}

\item{Mmax}{The maximum size of the polynomial basis from which \code{M} was selected (the default is \code{20}). See details.}

\item{smooth}{A logical argument indicating if a denoised solution should be implemented. The default is \code{FALSE}, meaning that the full solution should be implemented. See details.}

\item{criterion}{If \code{smooth=TRUE}, the criterion with respect to which the denoising process should be implemented. The two possibilities are \code{"AIC"} or \code{"BIC"}. See details.}

\item{hist.u}{A logical argument indicating if the CD-plot should be displayed or not. The default is \code{TRUE}.}

\item{breaks}{If \code{hist.u=TRUE}, the number of breaks of the CD-plot. The default is \code{20}.}

\item{ylim}{If \code{hist.u=TRUE}, the range of the y-axis of the CD-plot.}

\item{range}{Range of the data/search region considered. }

\item{sigma}{The significance level (in sigmas) with respect to which the confidence bands should be constructed. See details.}
}

\details{
The argument \code{data} collects the data for which we want to test if its distribution deviates from the one of the postulated model specified in the argument \code{g}. In Algeri, 2019, the sample specified under \code{data} corresponds to the source-free sample in the background calibration phase and to the physics sample in the signal search phase.
The value \code{M} selected determines the smoothness of the estimated comparison density, with smaller values of \code{M} leading to smoother estimates. The deviance test is used to select the value \code{M} which leads to the most significant deviation from the postulated model. The default value for \code{Mmax} is set to \code{20}. Notice that numerical issues may
arise for larger values of \code{Mmax}.
If \code{smooth=TRUE} the largest coefficient estimates are selected according to either the AIC or BIC criterion as described in Algeri, 2019 and Mukhopadhyay, 2017.
If \code{Mmax>1} and/or \code{smooth=TRUE}, post-selection Bonferroni's correction is automatically implemented to both the deviance test p-value and the confidence bands. The desired level of significance can be expressed as one minus the cdf of a standard normal evaluated at \code{sigma} (see Algeri, 2019).
}

\value{
\item{Deviance}{Value of the deviance test statistic.}
\item{Dev_pvalue}{Unadjusted p-value of the deviance test.}
\item{Dev_adj_pvalue}{Post-selection Bonferroni adjusted p-value of the deviance test.}
\item{kstar}{Number of coefficients selected by the denoising process. If \code{smooth=FALSE}, \code{kstar=M}.}
\item{dhat}{Function corresponding to the estimated comparison density in the u domain.}
\item{dhat.x}{Function corresponding to the estimated comparison density in the x domain.}
\item{SE}{Function corresponding to the estimated standard errors of the comparison density in the u domain.}
\item{LBf1}{Function corresponding to the lower bound of the confidence bands under  in u domain.}
\item{UBf1}{Function corresponding to the upper bound of the confidence bands in u domain.}
\item{f}{Function corresponding to the estimated density of the data.}
\item{u}{Vector of values corresponding to the cdf of the model specified in \code{g} evaluated at the vector \code{data}.}
\item{LP}{Estimates of the coefficients.}
\item{G}{Cumulative density function of the postulated model specified in the argument \code{g}.}
}


\references{
S. Algeri, 2019. Detecting new signals under background mismodelling.	<arXiv:1906.06615>.

S. Mukhopadhyay, 2017. Large-scale mode identification and data-driven sciences. Electronic Journal of Statistics 11 (2017), no. 1, 215--240.
}
\author{Sara Algeri}


\seealso{\code{\link{Legj}},\code{\link{BestM}},\code{\link{denoise}}.}
\examples{
#generaing data
x<-rnorm(1000,10,7)
xx<-x[x>=10 & x<=20]

#create suitable postulated quantile function of data
G<-pnorm(20,5,15)-pnorm(10,5,15)
g<-function(x){dnorm(x,5,15)/G}

#Choose best M
Mmax=20
range=c(10,20)
m<-BestM(data=xx,g, Mmax,range)

# vectorize postulated quantile function
g<-Vectorize(g)
u<-g(xx)

#M has to be sufficient big, otherwise dhatL2 function will crush.
#So,here we set m eqaul 6 as an example
m<-6
comp.density<-dhatL2(data=xx,g, M=m, Mmax=Mmax,smooth=FALSE,criterion="AIC",hist.u=TRUE,breaks=20,
         ylim=c(0,2.5),range=range,sigma=2)
}
\keyword{CD plot}
\keyword{Comparison density estimate}
\keyword{Deviance test}
