#' 20-item Dependency-Oriented and Achievement-Oriented Psychological Control Scale (DAPCS)
#'
#' @description
#' This dataset contains responses to a 20-item Dependency-Oriented and Achievement-Oriented Psychological Control Scale (DAPCS),
#' measuring four distinct factors of psychological control perceived by adolescents from their parents.
#'
#' @details
#' The data were collected in 2022 from a sample of 987 general high school students in China.
#' Among the participants, 406 were male and 581 were female, with a mean age of
#'  15.823 years (SD = 0.793).
#'
#' The DAPCS scale was developed by Soenens and Vansteenkiste (2010).
#' It consists of 20 items that are grouped into four distinct dimensions, each with demonstrated internal consistency:
#'
#' \itemize{
#'   \item \strong{Autonomy – Negative Reaction}:
#'   Measures the extent of negative parental responses to adolescents' autonomy.
#'   \emph{Reliability:} Cronbach's \eqn{\alpha} = 0.857
#'
#'   \item \strong{Dependence – Positive Reaction}:
#'   Measures the extent of positive parental responses to adolescents' dependence.
#'   \emph{Reliability:} Cronbach's \eqn{\alpha} = 0.817
#'
#'   \item \strong{Low Achievement – Negative Reaction}:
#'   Measures the extent of negative parental responses to adolescents' low academic achievement.
#'   \emph{Reliability:} Cronbach's \eqn{\alpha} = 0.885
#'
#'   \item \strong{High Achievement – Positive Reaction}:
#'   Measures the extent of positive parental responses to adolescents' high academic achievement.
#'   \emph{Reliability:} Cronbach's \eqn{\alpha} = 0.889
#' }
#'
#' The scale contains 20 items rated on a 5-point Likert scale, ranging from 1 = strongly disagree to 5 = strongly agree.
#' In the dataset in this \code{EFAfactors} package, the total scale
#' demonstrated a Cronbach's \eqn{\alpha} of 0.923, and the four subscales showed
#' Cronbach's \eqn{\alpha} ranging from 0.817 to 0.889, indicating good reliability.
#'
#' @references
#' Soenens, B., & Vansteenkiste, M. (2010). A theoretical upgrade of the concept of parental psychological control: Proposing new insights on the basis of self-determination theory. Developmental Review, 30(1), 74–99.
#'
#' @examples
#' data(data.DAPCS)
#' response <- data.DAPCS[, -c(1, 2)]
#' head(response)
#'
#' @docType data
#' @name data.DAPCS
NULL
