% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexis_age.R
\name{lexis_age}
\alias{lexis_age}
\title{Emphasize a certain age in Lexis grid}
\usage{
lexis_age(lg, age, delta = 1, fill = lexisplotr_colours()[1],
  alpha = 0.7)
}
\arguments{
\item{lg, }{an existing object originally created with \code{lexis_grid()}.}

\item{age}{numeric, set the age to highlight.}

\item{delta}{numeric, set the size of the age groups. Default is 1.}

\item{fill}{character, set colour to fill the rectangle.}

\item{alpha}{numeric, set alpha, the level of transparency for \code{fill}. Default is \code{0.5}.}
}
\value{
A ggplot2 object.
}
\description{
Add a coloured rectangle to an existing Lexis grid to highlight a certain age in that Lexis grid.
}
\details{
Takes an existing Lexis grid and adds a coloured rectangle that highlights all triangles belonging to a certain age.
}
\examples{
library(LexisPlotR)
lexis <- lexis_grid(year_start = 1900, year_end = 1905, age_start = 0, age_end = 5)
lexis <- lexis_age(lg = lexis, age = 3)
}
\author{
Philipp Ottolinger
}
