% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_Date_col.R
\name{add_Date_col}
\alias{add_Date_col}
\title{Create a Date column in the dataset}
\usage{
add_Date_col(
  dataset,
  Date.colname = Date,
  group.by = FALSE,
  as.wday = FALSE,
  as.count = FALSE,
  Datetime.colname = Datetime
)
}
\arguments{
\item{dataset}{A light logger dataset. Expects a \code{dataframe}. If not imported
by \link{LightLogR}, take care to choose a sensible variable for the
\code{Datetime.colname}.}

\item{Date.colname}{Name of the newly created column. Expects a \code{symbol}. The
default(\code{Date}) works well with other functions in \link{LightLogR}. Will
overwrite existing columns of identical name.}

\item{group.by}{Logical whether the output should be (additionally) grouped
by the new column}

\item{as.wday}{Logical of whether the added column should calculate day of
the week instead of date. If \code{TRUE} will create a factor with weekday
abbreviations, where the week starts with \code{Mon}. Will be ignored if
\code{as.count = TRUE}.}

\item{as.count}{Logical of whether the added column should give a day
count from the starting day of the group.}

\item{Datetime.colname}{column name that contains the datetime. Defaults to
\code{"Datetime"} which is automatically correct for data imported with
\link{LightLogR}. Expects a \code{symbol}. Needs to be part of the \code{dataset}. Must
be of type \code{POSIXct}.}
}
\value{
a \code{data.frame} object identical to \code{dataset} but with the added
column of Date data
}
\description{
Create a Date column in the dataset
}
\examples{
sample.data.environment \%>\% add_Date_col()
#days of the week
sample.data.environment \%>\% 
  add_Date_col(as.wday = TRUE, group.by = TRUE) |> 
  summarize_numeric(remove = c("Datetime"))

}
