% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_States.R
\name{import_Statechanges}
\alias{import_Statechanges}
\title{Import data that contain \code{Datetimes} of \code{Statechanges}}
\usage{
import_Statechanges(
  filename,
  path = NULL,
  sep = ",",
  dec = ".",
  structure = c("wide", "long"),
  Datetime.format = "ymdHMS",
  tz = "UTC",
  State.colnames,
  State.encoding = State.colnames,
  Datetime.column = Datetime,
  Id.colname,
  State.newname = State,
  Id.newname = Id,
  keep.all = FALSE,
  silent = FALSE
)
}
\arguments{
\item{filename}{Filename(s) for the Dataset. Can also contain the filepath,
but \code{path} must then be \code{NULL}. Expects a \code{character}. If the vector is
longer than \code{1}, multiple files will be read in into one Tibble.}

\item{path}{Optional path for the dataset(s). \code{NULL} is the default. Expects
a \code{character}.}

\item{sep}{String that separates columns in the import file. Defaults to
\code{","}.}

\item{dec}{String that indicates a decimal separator in the import file.
Defaults to \code{"."}.}

\item{structure}{String that specifies whether the import file is in the
\code{long} or \code{wide} format. Defaults to \code{"wide"}.}

\item{Datetime.format}{String that specifies the format of the \code{Datetimes} in
the file. The default \code{"ymdHMS"} specifies a format like "2023-07-10
10:00:00". In the function, \code{\link[lubridate:parse_date_time]{lubridate::parse_date_time()}} does the actual
conversion - the documentation can be searched for valid inputs.}

\item{tz}{Timezone of the data. \code{"UTC"} is the default. Expects a
\code{character}. You can look up the supported timezones with \code{\link[=OlsonNames]{OlsonNames()}}.}

\item{State.colnames}{Column name or vector of column names (the latter only
in the \code{wide} format). Expects a \code{character}.
\itemize{
\item In the \code{wide} format, the column names indicate the \code{State} and must contain \code{Datetimes}. The columns will be pivoted to the columns specified in \code{Datetime.column} and \code{State.newname}.
\item In the \code{long} format, the column contains the \code{State}
}}

\item{State.encoding}{In the \code{wide} format, this enables recoding the column
names to state names, if there are any differences. The default uses the
\code{State.colnames} argument. Expects a \code{character} (vector) with the same
length as \code{State.colnames}.}

\item{Datetime.column}{Symbol of the \code{Datetime} column (which is also the
default).
\itemize{
\item In the \code{wide} format, this is the newly created column from the \code{Datetimes} in the \code{State.colnames}.
\item In the \code{long} format, this is the existing column that contains the \code{Datetimes}.
}}

\item{Id.colname}{Symbol of the column that contains the \code{ID} of the subject.}

\item{State.newname}{Symbol of the column that will contain the \code{State} of
the subject. In the \code{wide} format, this is the newly created column from
the \code{State.colnames}. In the \code{long} format, this argument is used to rename
the \code{State} column.}

\item{Id.newname}{Column name used for renaming the \code{Id.colname} column.}

\item{keep.all}{Logical that specifies whether all columns should be
kept in the output. Defaults to \code{FALSE}.}

\item{silent}{Logical that specifies whether a summary of the
imported data should be shown. Defaults to \code{FALSE}.}
}
\value{
a dataset with the \code{ID}, \code{State}, and \code{Datetime} columns. May contain
additional columns if \code{keep.all} is \code{TRUE}.
}
\description{
Auxiliary data greatly enhances data analysis. This function allows the
import of files that contain \code{Statechanges}, i.e., specific time points of
when a \code{State} (like \code{sleep} or \code{wake}) starts.
}
\details{
Data can be present in the long or wide format.
\itemize{
\item In the \code{wide} format, multiple \code{Datetime} columns indicate the state through the column name. These get pivoted to the \code{long} format and can be recoded through the \code{State.encoding} argument.
\item In the \code{long} format, one column indicates the \code{State}, while the other gives the \code{Datetime}.
}
}
\examples{
#get the example file from within the package
path <- system.file("extdata/",
package = "LightLogR")
file.sleep <- "205_sleepdiary_all_20230904.csv"

#import Data in the wide format (sleep/wake times)
import_Statechanges(file.sleep, path,
Datetime.format = "dmyHM",
State.colnames = c("sleep", "offset"),
State.encoding = c("sleep", "wake"),
Id.colname = record_id,
sep = ";",
dec = ",")

#import in the long format (Comments on sleep)
import_Statechanges(file.sleep, path,
                   Datetime.format = "dmyHM",
                   State.colnames = "comments",
                   Datetime.column = sleep,
                   Id.colname = record_id,
                   sep = ";",
                   dec = ",", structure = "long")
}
