% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_plots.R
\name{LoTTA_plot_outcome}
\alias{LoTTA_plot_outcome}
\title{LoTTA_plot_outcome}
\usage{
LoTTA_plot_outcome(
  LoTTA_posterior,
  nbins = 100,
  probs = c(0.025, 0.5, 0.975),
  n_eval = 200,
  col_line = "#E69F00",
  size_line = 0.1,
  alpha_interval = 0.35,
  col_dots = "gray",
  size_dots = 3,
  alpha_dots = 0.6,
  col_cutoff = "black",
  title = "Outcome function",
  subtitle = NULL,
  y_lab = "",
  x_lab = expression(paste(italic("x"), " - score")),
  plot.theme = theme_classic(base_size = 14),
  legend.position = "none",
  name_legend = "Legend",
  labels_legend = "median outcome fun.",
  text = element_text(family = "serif"),
  legend.text = element_text(size = 14),
  plot.title = element_text(hjust = 0.5),
  plot.subtitle = element_text(hjust = 0.5),
  ...
)
}
\arguments{
\item{LoTTA_posterior}{\itemize{
\item output of one of the LoTTA functions (LoTTA_sharp_CONT, LoTTA_fuzzy_CONT, LoTTA_sharp_BIN, LoTTA_fuzzy_BIN)
with all the parameters sampled (the default option in those functions)
}}

\item{nbins}{\itemize{
\item number of bins to aggregate the input data
}}

\item{probs}{\itemize{
\item list of three quantiles, the first and the last one define the quanatile-based credible interval,
the middle value defines the quantile of the posterior function to plot;
by default the quantiles correspond to the median posterior function and 95\% credible interval
probs=c(0.025,0.5,0.975)
}}

\item{n_eval}{\itemize{
\item n_eval*range(x) is the number of points at which each posterior function is evaluated,
the higher number means slower computing time and a smoother plot; default n_eval=200
}}

\item{col_line}{\itemize{
\item the color of the line and the band
}}

\item{size_line}{\itemize{
\item thickness of the line
}}

\item{alpha_interval}{\itemize{
\item alpha value of the band, lower values correspond to a more transparent color
}}

\item{col_dots}{\itemize{
\item color of the dots that correspond to the binned data
}}

\item{size_dots}{\itemize{
\item size of the dots that correspond to the binned data
}}

\item{alpha_dots}{\itemize{
\item transparency of the dots that correspond to the binned data,
lower values correspond to a more transparent color
}}

\item{col_cutoff}{\itemize{
\item color of the dotted line at the cutoff
}}

\item{title}{\itemize{
\item title of the plot
}}

\item{subtitle}{\itemize{
\item subtitle of the plot
}}

\item{y_lab}{\itemize{
\item label of the y-axis
}}

\item{x_lab}{\itemize{
\item label of the x-axis
}}

\item{plot.theme}{\itemize{
\item ggplot2 plot theme (see https://ggplot2.tidyverse.org/reference/ggtheme.html)
possibly with additional arguments, it takes the default value plot.theme=theme_classic(base_size = 14),
}}

\item{legend.position}{\itemize{
\item position of the legend, refer to ggplot2 manual for the possible values;
by default legend is not printed legend.position='none'
}}

\item{name_legend}{\itemize{
\item title of the legend
}}

\item{labels_legend}{\itemize{
\item the label of the plotted function in the legend
}}

\item{text}{\itemize{
\item can be any value that is accepted in the argument \emph{text} in the \emph{theme} function
of ggplot2 package,refer to ggplot2 manual for the possible values;
by default is changes font to a serif one text=element_text(family='serif')
}}

\item{legend.text}{\itemize{
\item can be any value that is accepted in the argument \emph{legend.text} in the \emph{theme} function
of ggplot2 package,refer to ggplot2 manual for the possible values;
by default is changes font size to the legend to 14 legend.text=element_text(size = 14)
}}

\item{plot.title}{\itemize{
\item can be any value that is accepted in the argument \emph{plot.title} in the \emph{theme} function
of ggplot2 package,refer to ggplot2 manual for the possible values;
by default it centers the plot title plot.title = element_text(hjust = 0.5)
}}

\item{plot.subtitle}{\itemize{
\item can be any value that is accepted in the argument \emph{plot.subtitle} in the \emph{theme} function
of ggplot2 package,refer to ggplot2 manual for the possible values;
by default it centers the plot subtitle plot.title = element_text(hjust = 0.5)
}}

\item{...}{\itemize{
\item other arguments of the \emph{theme} function, refer to ggplot2 manual
}}
}
\value{
ggplot2 object
}
\description{
Function that plots the median (or another quantile) of the LoTTA posterior outcome function along with the quanatile-based credible interval.
The function is plotted on top of the binned input data. To bin the data, the score data
is divided into bins of fixed length, then the average outcome in each bin is calculated.
The average outcomes are plotted against the average values of the score in the corresponding bins.
The data is binned separately on each side of the cutoff, the cutoff is marked on the plot
with a dotted line. In case of an unknown cutoff, the MAP estimate is used.
}
\examples{
# functions to generate the data

ilogit <- function(x) {
  return(1 / (1 + exp(-x)))
}

funB <- function(x) {
  y = x
  x2 = x[x >= 0]
  x1 = x[x < 0]
  y[x < 0] = 1 / (1 + exp(-2 * x1)) - 0.5 + 0.4
  y[x >= 0] = (log(x2 * 2 + 1) - 0.15 * x2^2) * 0.6 - 0.20 + 0.4
  return(y)
}

funB_sample <- function(x) {
  y = funB(x)+ rnorm(length(x), 0, 0.1)
  return(y)
}
## Toy example - for the function check only! ##
# data generation
N=100
set.seed(1234)
x = sort(runif(N, -1, 1))
y = funB_sample(x)
c = 0

# running LoTTA function on sharp RDD with continuous outcomes;
out = LoTTA_sharp_CONT(x, y, c,normalize=FALSE, burnin = 100, sample = 100, adapt = 100,
n.chains=1, seed = NULL,method = 'simple',inits = NA)
# plot the outcome
LoTTA_plot_outcome(out,n_eval = 100)

## Use case example ##
\donttest{# data generation
  N=500 # try different dataset size
  x = sort(runif(N, -1, 1))
  y = funB_sample(x)
  c = 0
  # plot the data
  plot(x,y)
  # running LoTTA function on sharp RDD with continuous outcomes;
  # cutoff = 0, treatment effect = -0.2
  # remember to check convergence and adjust burnin, sample and adapt if needed
  out = LoTTA_sharp_CONT(x, y, c, burnin = 10000, sample = 5000, adapt = 1000,n.chains=4)
  # print effect estimate:
  out$Effect_estimate
  # print JAGS output to asses convergence (the output is for normalized data)
  out$JAGS_output
  # plot posterior fit
  LoTTA_plot_outcome(out)}
}
