% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConsensusLoops.R
\name{ConsensusLoops}
\alias{ConsensusLoops}
\title{Subset an object of class LoopRanges using consensus options}
\usage{
ConsensusLoops(loop_ranges, stringency = 1, overlap_threshold = 1,
  split_anchors = FALSE, resolutions = NULL, keep_all = FALSE)
}
\arguments{
\item{loop_ranges}{An object of 'LoopRanges' class created from the LoopsToRanges() function}

\item{stringency}{Integer (n>=0) indicating the number of looping datasets a loop from a given dataset must overlap with to be considered a consensus loop}

\item{overlap_threshold}{Single numerical input in either percentage (0<=n<=1) overlap format if split_anchors = TRUE, or in base pair number format (n>=0) in split_anchors=FALSE (default=1)}

\item{split_anchors}{A boolean (TRUE/FALSE) that determines if the different loop anchor sizes are considered together (default=TRUE) or separately (FALSE)}

\item{resolutions}{An optional numerical vector of anchor sizes - to be used only when split_anchors=TRUE}

\item{keep_all}{If TRUE, keeps all of the loops (concatenation of looping datasets)}
}
\value{
A 'LoopRanges' class object for the consensus loops
}
\description{
Performs filtering on looping data in LoopRanges objects based on custom parameters and returns a single GRangesList object indicating one looping dataset with two anchors
}
\examples{
# Load loops into LoopRanges object 
ovary_loops <- system.file("extdata/loops", "ovary_hg19.bedpe", 
package = "LoopRig", mustWork = TRUE) 
spleen_loops <- system.file("extdata/loops", "spleen_hg19.bedpe", 
package = "LoopRig", mustWork = TRUE)
pancreas_loops <- system.file("extdata/loops", "pancreas_hg19.bedpe", 
package = "LoopRig", mustWork = TRUE)
loops <- LoopsToRanges(ovary_loops, spleen_loops, pancreas_loops, custom_cols = 0)

# Determine consensus loops based on overlap of 1 bp in at least 2 datasets
ConsensusLoops(loops, stringency = 2, overlap_threshold = 1)
}
